/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup.rule.impl;

import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.Dimensions;
import com.liferay.portal.kernel.mobile.device.rulegroup.rule.RuleHandler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SimpleRuleHandler
implements RuleHandler {
    public static final String PROPERTY_OS = "os";
    public static final String PROPERTY_SCREEN_PHYSICAL_HEIGHT_MAX = "screen-physical-height-max";
    public static final String PROPERTY_SCREEN_PHYSICAL_HEIGHT_MIN = "screen-physical-height-min";
    public static final String PROPERTY_SCREEN_PHYSICAL_WIDTH_MAX = "screen-physical-width-max";
    public static final String PROPERTY_SCREEN_PHYSICAL_WIDTH_MIN = "screen-physical-width-min";
    public static final String PROPERTY_SCREEN_RESOLUTION_HEIGHT_MAX = "screen-resolution-height-max";
    public static final String PROPERTY_SCREEN_RESOLUTION_HEIGHT_MIN = "screen-resolution-height-min";
    public static final String PROPERTY_SCREEN_RESOLUTION_WIDTH_MAX = "screen-resolution-width-max";
    public static final String PROPERTY_SCREEN_RESOLUTION_WIDTH_MIN = "screen-resolution-width-min";
    public static final String PROPERTY_TABLET = "tablet";
    private static Collection<String> _propertyNames = new ArrayList<String>(10);

    static {
        _propertyNames.add(PROPERTY_OS);
        _propertyNames.add(PROPERTY_SCREEN_PHYSICAL_WIDTH_MAX);
        _propertyNames.add(PROPERTY_SCREEN_PHYSICAL_WIDTH_MIN);
        _propertyNames.add(PROPERTY_SCREEN_PHYSICAL_HEIGHT_MAX);
        _propertyNames.add(PROPERTY_SCREEN_PHYSICAL_HEIGHT_MIN);
        _propertyNames.add(PROPERTY_SCREEN_RESOLUTION_WIDTH_MAX);
        _propertyNames.add(PROPERTY_SCREEN_RESOLUTION_WIDTH_MIN);
        _propertyNames.add(PROPERTY_SCREEN_RESOLUTION_HEIGHT_MAX);
        _propertyNames.add(PROPERTY_SCREEN_RESOLUTION_HEIGHT_MIN);
        _propertyNames.add(PROPERTY_TABLET);
        _propertyNames = Collections.unmodifiableCollection(_propertyNames);
    }

    public static String getHandlerType() {
        return SimpleRuleHandler.class.getName();
    }

    public boolean evaluateRule(MDRRule mdrRule, ThemeDisplay themeDisplay) {
        boolean tabletBoolean;
        Object[] operatingSystems;
        Device device = themeDisplay.getDevice();
        if (device == null || Validator.isNull((String)device.getOS())) {
            return false;
        }
        UnicodeProperties typeSettingsProperties = mdrRule.getTypeSettingsProperties();
        String os = (String)typeSettingsProperties.get((Object)PROPERTY_OS);
        if (Validator.isNotNull((String)os) && !ArrayUtil.contains((Object[])(operatingSystems = StringUtil.split((String)os)), (Object)device.getOS())) {
            return false;
        }
        String tablet = (String)typeSettingsProperties.get((Object)PROPERTY_TABLET);
        if (Validator.isNotNull((String)tablet) && (tabletBoolean = GetterUtil.getBoolean((String)tablet)) != device.isTablet()) {
            return false;
        }
        Dimensions screenPhysicalSize = device.getScreenPhysicalSize();
        if (!this.isValidValue(screenPhysicalSize.getHeight(), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_PHYSICAL_HEIGHT_MAX), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_PHYSICAL_HEIGHT_MIN))) {
            return false;
        }
        if (!this.isValidValue(screenPhysicalSize.getWidth(), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_PHYSICAL_WIDTH_MAX), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_PHYSICAL_WIDTH_MIN))) {
            return false;
        }
        Dimensions screenResolution = device.getScreenResolution();
        if (!this.isValidValue(screenResolution.getHeight(), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_RESOLUTION_HEIGHT_MAX), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_RESOLUTION_HEIGHT_MIN))) {
            return false;
        }
        return this.isValidValue(screenResolution.getWidth(), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_RESOLUTION_WIDTH_MAX), (String)typeSettingsProperties.get((Object)PROPERTY_SCREEN_RESOLUTION_WIDTH_MIN));
    }

    public Collection<String> getPropertyNames() {
        return _propertyNames;
    }

    public String getType() {
        return SimpleRuleHandler.getHandlerType();
    }

    protected boolean isValidValue(float value, String max, String min) {
        float minFLoat;
        float maxFloat;
        if (Validator.isNull((String)max) && Validator.isNull((String)min)) {
            return true;
        }
        if (Validator.isNotNull((String)max) && value > (maxFloat = GetterUtil.getFloat((String)max))) {
            return false;
        }
        return !Validator.isNotNull((String)min) || !(value < (minFLoat = GetterUtil.getFloat((String)min)));
    }
}

