/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.metadata.XMPDM;
import com.liferay.portal.metadata.XugglerRawMetadataProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;

public class TikaRawMetadataProcessor
extends XugglerRawMetadataProcessor {
    private static Log _log = LogFactoryUtil.getLog(TikaRawMetadataProcessor.class);
    private Parser _parser;

    public void setParser(Parser parser) {
        this._parser = parser;
    }

    protected Metadata extractMetadata(InputStream inputStream, Metadata metadata) throws IOException {
        if (metadata == null) {
            metadata = new Metadata();
        }
        ParseContext parserContext = new ParseContext();
        parserContext.set(Parser.class, (Object)this._parser);
        WriteOutContentHandler contentHandler = new WriteOutContentHandler((Writer)new DummyWriter());
        try {
            this._parser.parse(inputStream, (ContentHandler)contentHandler, metadata, parserContext);
        }
        catch (Exception e2) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)e2);
            if (throwable instanceof CryptographyException || throwable instanceof EncryptedDocumentException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to extract metadata from an encrypted file");
                }
            } else {
                _log.error((Object)e2, (Throwable)e2);
            }
            throw new IOException(e2.getMessage());
        }
        metadata.remove(XMPDM.ABS_PEAK_AUDIO_FILE_PATH.getName());
        metadata.remove(XMPDM.RELATIVE_PEAK_AUDIO_FILE_PATH.getName());
        return metadata;
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, File file) throws SystemException {
        Metadata metadata;
        Metadata metadata2 = super.extractMetadata(extension, mimeType, file);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            metadata = this.extractMetadata(inputStream, metadata2);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((InputStream)inputStream);
        return metadata;
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, InputStream inputStream) throws SystemException {
        Metadata metadata = super.extractMetadata(extension, mimeType, inputStream);
        try {
            return this.extractMetadata(inputStream, metadata);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }
}

