/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.BaseProxyBean;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import com.liferay.util.aspectj.AspectJUtil;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;

public class MessagingProxyAdvice {
    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Message message = new Message();
        ProxyRequest proxyRequest = this.createProxyRequest(proceedingJoinPoint);
        message.setPayload((Object)proxyRequest);
        Map messageValues = MessageValuesThreadLocal.getValues();
        if (!messageValues.isEmpty()) {
            for (String key : messageValues.keySet()) {
                message.put(key, messageValues.get(key));
            }
        }
        BaseProxyBean baseProxyBean = (BaseProxyBean)proceedingJoinPoint.getTarget();
        if (proxyRequest.isSynchronous() || ProxyModeThreadLocal.isForceSync()) {
            return this.doInvokeSynchronous(message, baseProxyBean, proceedingJoinPoint);
        }
        this.doInvokeAsynchronous(message, baseProxyBean);
        return null;
    }

    protected ProxyRequest createProxyRequest(ProceedingJoinPoint proceedingJoinPoint) throws Exception {
        return new ProxyRequest(AspectJUtil.getMethod((ProceedingJoinPoint)proceedingJoinPoint), proceedingJoinPoint.getArgs());
    }

    protected void doInvokeAsynchronous(Message message, BaseProxyBean baseProxyBean) {
        SingleDestinationMessageSender messageSender = baseProxyBean.getSingleDestinationMessageSender();
        if (messageSender == null) {
            throw new IllegalStateException("Asynchronous message sender was not configured properly for " + baseProxyBean.getClass().getName());
        }
        messageSender.send(message);
    }

    protected Object doInvokeSynchronous(Message message, BaseProxyBean baseProxyBean, ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        SingleDestinationSynchronousMessageSender messageSender = baseProxyBean.getSingleDestinationSynchronousMessageSender();
        if (messageSender == null) {
            throw new IllegalStateException("Synchronous message sender was not configured properly for " + baseProxyBean.getClass().getName());
        }
        ProxyResponse proxyResponse = (ProxyResponse)messageSender.send(message);
        if (proxyResponse == null) {
            return proceedingJoinPoint.proceed();
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }
}

