/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.async;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.Validator;

public class AsyncMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(AsyncMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        String responseDestinationName;
        block3: {
            responseDestinationName = message.getResponseDestinationName();
            Runnable runnable = (Runnable)message.getPayload();
            try {
                runnable.run();
            }
            catch (RuntimeException re) {
                if (!Validator.isNotNull((String)responseDestinationName) || !_log.isWarnEnabled()) break block3;
                _log.warn((Object)re, (Throwable)re);
            }
        }
        if (Validator.isNotNull((String)responseDestinationName)) {
            Message responseMessage = MessageBusUtil.createResponseMessage((Message)message);
            MessageBusUtil.sendMessage((String)responseDestinationName, (Message)responseMessage);
        }
    }
}

