/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.async;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;

public class AsyncAdvice
extends AnnotationChainableMethodAdvice<Async> {
    private static Log _log = LogFactoryUtil.getLog(AsyncAdvice.class);
    private static Async _nullAsync = new Async(){

        public Class<? extends Annotation> annotationType() {
            return Async.class;
        }
    };
    private String _defaultDestinationName;
    private Map<Class<?>, String> _destinationNames;

    @Override
    public Object before(final MethodInvocation methodInvocation) throws Throwable {
        Async async = (Async)this.findAnnotation(methodInvocation);
        if (async == _nullAsync) {
            return null;
        }
        Method method = methodInvocation.getMethod();
        if (method.getReturnType() != Void.TYPE) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Async annotation on method " + method.getName() + " does not return void"));
            }
            return null;
        }
        String destinationName = null;
        if (this._destinationNames != null && !this._destinationNames.isEmpty()) {
            Object thisObject = methodInvocation.getThis();
            destinationName = this._destinationNames.get(thisObject.getClass());
        }
        if (destinationName == null) {
            destinationName = this._defaultDestinationName;
        }
        MessageBusUtil.sendMessage((String)destinationName, (Object)new Runnable(){

            @Override
            public void run() {
                try {
                    methodInvocation.proceed();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }

            public String toString() {
                return methodInvocation.toString();
            }
        });
        return this.nullResult;
    }

    public String getDefaultDestinationName() {
        return this._defaultDestinationName;
    }

    @Override
    public Async getNullAnnotation() {
        return _nullAsync;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        this._defaultDestinationName = defaultDestinationName;
    }

    public void setDestinationNames(Map<Class<?>, String> destinationNames) {
        this._destinationNames = destinationNames;
    }
}

