/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.util;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.license.LicenseManager;
import com.liferay.portal.license.util.LicenseManagerUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class LicenseUtil {
    public static final String LICENSE_REPOSITORY_DIR = PropsValues.LIFERAY_HOME.concat("/data/license");
    public static final String LICENSE_SERVER_URL = GetterUtil.get((String)PropsUtil.get("license.server.url"), (String)"https://www.liferay.com");
    private static final String _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get("license.proxy.password"));
    private static final int _PROXY_PORT = GetterUtil.getInteger((String)PropsUtil.get("license.proxy.port"), (int)80);
    private static final String _PROXY_URL = PropsUtil.get("license.proxy.url");
    private static final String _PROXY_USER_NAME = GetterUtil.getString((String)PropsUtil.get("license.proxy.username"));
    private static Log _log = LogFactoryUtil.getLog(LicenseUtil.class);
    private static String _encryptedSymmetricKey;
    private static MethodHandler _getServerInfoMethodHandler;
    private static String _hostName;
    private static Set<String> _ipAddresses;
    private static Set<String> _macAddresses;
    private static Pattern _macAddressPattern1;
    private static Pattern _macAddressPattern2;
    private static MethodKey _registerOrderMethodKey;
    private static byte[] _serverIdBytes;
    private static Key _symmetricKey;

    static {
        _getServerInfoMethodHandler = new MethodHandler(new MethodKey(LicenseUtil.class, "getServerInfo", new Class[0]), new Object[0]);
        _macAddressPattern1 = Pattern.compile("\\s((\\p{XDigit}{2}(-|:)){5}(\\p{XDigit}{2}))(?:\\s|$)");
        _macAddressPattern2 = Pattern.compile("\\s((\\p{XDigit}{1,2}(\\.)){5}(\\p{XDigit}{1,2}))(?:\\s|$)");
        _registerOrderMethodKey = new MethodKey(LicenseUtil.class, "registerOrder", new Class[]{String.class, String.class, Integer.TYPE});
        LicenseUtil._initKeys();
    }

    public static Map<String, String> getClusterServerInfo(String clusterNodeId) throws Exception {
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        ClusterNode clusterNode = null;
        for (ClusterNode curClusterNode : clusterNodes) {
            String curClusterNodeId = curClusterNode.getClusterNodeId();
            if (!curClusterNodeId.equals(clusterNodeId)) continue;
            clusterNode = curClusterNode;
            break;
        }
        if (clusterNode == null) {
            return null;
        }
        try {
            if (clusterNode.equals((Object)ClusterExecutorUtil.getLocalClusterNode())) {
                return LicenseUtil.getServerInfo();
            }
            ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)_getServerInfoMethodHandler, (String[])new String[]{clusterNodeId});
            FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode);
            return (Map)clusterNodeResponse.getResult();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw e2;
        }
    }

    public static String getHostName() {
        if (_hostName != null) {
            return _hostName;
        }
        _hostName = "";
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("hostname");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
            _hostName = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to read local server's host name");
            _log.error((Object)e2, (Throwable)e2);
        }
        return _hostName;
    }

    public static Set<String> getIpAddresses() {
        if (_ipAddresses != null) {
            return new HashSet<String>(_ipAddresses);
        }
        _ipAddresses = new HashSet<String>();
        try {
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : networkInterfaces) {
                ArrayList<InetAddress> inetAddresses = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress inetAddress : inetAddresses) {
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    _ipAddresses.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to read local server's IP addresses");
            _log.error((Object)e2, (Throwable)e2);
        }
        return new HashSet<String>(_ipAddresses);
    }

    public static Set<String> getMacAddresses() {
        if (_macAddresses != null) {
            return new HashSet<String>(_macAddresses);
        }
        Set<String> macAddresses = new HashSet<String>();
        String osName = System.getProperty("os.name");
        String executable = null;
        String arguments = null;
        if (StringUtil.startsWith((String)osName, (String)"win")) {
            executable = "ipconfig";
            arguments = "/all";
        } else {
            if (StringUtil.startsWith((String)osName, (String)"aix")) {
                executable = "netstat";
                arguments = "-ina";
            } else {
                executable = "ifconfig";
                arguments = "-a";
            }
            File sbinDir = new File("/sbin", executable);
            if (sbinDir.exists()) {
                executable = "/sbin/".concat(executable);
            }
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{executable, arguments});
            macAddresses = LicenseUtil.getMacAddresses(osName, process.getInputStream());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        _macAddresses = macAddresses;
        return new HashSet<String>(macAddresses);
    }

    public static Set<String> getMacAddresses(String osName, InputStream processInputStream) throws Exception {
        String[] lines;
        HashSet<String> macAddresses = new HashSet<String>();
        Pattern macAddressPattern = _macAddressPattern1;
        if (StringUtil.startsWith((String)osName, (String)"aix")) {
            macAddressPattern = _macAddressPattern2;
        }
        String processOutput = StringUtil.read((InputStream)processInputStream);
        String[] stringArray = lines = StringUtil.split((String)processOutput, (char)'\n');
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = macAddressPattern.matcher(line);
            if (matcher.find()) {
                String macAddress = matcher.group(1);
                macAddress = macAddress.toLowerCase();
                macAddress = macAddress.replace('-', ':');
                macAddress = macAddress.replace('.', ':');
                StringBuilder sb = new StringBuilder(17);
                sb.append(macAddress);
                int i2 = 1;
                while (i2 < 5) {
                    int pos = i2 * 3 - 1;
                    if (sb.charAt(pos) != ':') {
                        sb.insert((i2 - 1) * 3, '0');
                    }
                    ++i2;
                }
                if (sb.length() < 17) {
                    sb.insert(15, '0');
                }
                macAddress = sb.toString();
                macAddresses.add(macAddress);
            }
            ++n2;
        }
        return macAddresses;
    }

    public static byte[] getServerIdBytes() throws Exception {
        if (_serverIdBytes != null) {
            return _serverIdBytes;
        }
        File serverIdFile = new File(String.valueOf(LICENSE_REPOSITORY_DIR) + "/server/serverId");
        if (!serverIdFile.exists()) {
            return new byte[0];
        }
        _serverIdBytes = FileUtil.getBytes((File)serverIdFile);
        return _serverIdBytes;
    }

    public static Map<String, String> getServerInfo() {
        HashMap<String, String> serverInfo = new HashMap<String, String>();
        serverInfo.put("hostName", LicenseUtil.getHostName());
        serverInfo.put("ipAddresses", StringUtil.merge(LicenseUtil.getIpAddresses()));
        serverInfo.put("macAddresses", StringUtil.merge(LicenseUtil.getMacAddresses()));
        return serverInfo;
    }

    public static void registerOrder(HttpServletRequest request) {
        String orderUuid = ParamUtil.getString((HttpServletRequest)request, (String)"orderUuid");
        String productEntryName = ParamUtil.getString((HttpServletRequest)request, (String)"productEntryName");
        int maxServers = ParamUtil.getInteger((HttpServletRequest)request, (String)"maxServers");
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        if (clusterNodes.size() <= 1 || Validator.isNull((String)productEntryName) || Validator.isNull((String)orderUuid)) {
            Map<String, Object> attributes = LicenseUtil.registerOrder(orderUuid, productEntryName, maxServers);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        } else {
            for (ClusterNode clusterNode : clusterNodes) {
                boolean register = ParamUtil.getBoolean((HttpServletRequest)request, (String)(String.valueOf(clusterNode.getClusterNodeId()) + "_register"));
                if (!register) continue;
                try {
                    LicenseUtil._registerClusterOrder(request, clusterNode, orderUuid, productEntryName, maxServers);
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                    InetAddress inetAddress = clusterNode.getInetAddress();
                    String message = "Error contacting " + inetAddress.getHostName();
                    if (clusterNode.getPort() != -1) {
                        message = String.valueOf(message) + ":" + clusterNode.getPort();
                    }
                    request.setAttribute(String.valueOf(clusterNode.getClusterNodeId()) + "_ERROR_MESSAGE", (Object)message);
                }
            }
        }
    }

    public static Map<String, Object> registerOrder(String orderUuid, String productEntryName, int maxServers) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (Validator.isNull((String)orderUuid)) {
            return attributes;
        }
        try {
            JSONObject jsonObject = LicenseUtil._createRequest(orderUuid, productEntryName, maxServers);
            String response = LicenseUtil.sendRequest(jsonObject.toString());
            JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)response);
            attributes.put("ORDER_PRODUCT_ID", responseJSONObject.getString("productId"));
            attributes.put("ORDER_PRODUCTS", LicenseUtil._getOrderProducts(responseJSONObject));
            String errorMessage = responseJSONObject.getString("errorMessage");
            if (Validator.isNotNull((String)errorMessage)) {
                attributes.put("ERROR_MESSAGE", errorMessage);
                return attributes;
            }
            String licenseXML = responseJSONObject.getString("licenseXML");
            if (Validator.isNotNull((String)licenseXML)) {
                LicenseManagerUtil.registerLicense((JSONObject)responseJSONObject);
                attributes.clear();
                attributes.put("SUCCESS_MESSAGE", "Your license has been successfully registered.");
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            attributes.put("ERROR_MESSAGE", "There was an error contacting " + LICENSE_SERVER_URL);
        }
        return attributes;
    }

    public static String sendRequest(String request) throws Exception {
        String string;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String serverURL = LICENSE_SERVER_URL;
            if (!serverURL.endsWith("/")) {
                serverURL = String.valueOf(serverURL) + "/";
            }
            serverURL = String.valueOf(serverURL) + "osb-portlet/license";
            URL url = new URL(serverURL);
            URLConnection connection = null;
            if (Validator.isNotNull((String)_PROXY_URL)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Using proxy " + _PROXY_URL + ":" + _PROXY_PORT));
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(_PROXY_URL, _PROXY_PORT));
                connection = url.openConnection(proxy);
                if (Validator.isNotNull((String)_PROXY_USER_NAME)) {
                    String login = String.valueOf(_PROXY_USER_NAME) + ":" + _PROXY_PASSWORD;
                    String encodedLogin = Base64.encode((byte[])login.getBytes());
                    connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedLogin);
                }
            } else {
                connection = url.openConnection();
            }
            connection.setDoOutput(true);
            outputStream = connection.getOutputStream();
            outputStream.write(LicenseUtil._encryptRequest(serverURL, request));
            String response = LicenseUtil._decryptResponse(serverURL, connection.getInputStream());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Server response: " + response));
            }
            if (Validator.isNull((String)response)) {
                throw new Exception("Server response is null");
            }
            string = response;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public static void writeServerProperties(byte[] serverIdBytes) throws Exception {
        File serverIdFile = new File(String.valueOf(LICENSE_REPOSITORY_DIR) + "/server/serverId");
        FileUtil.write((File)serverIdFile, (byte[])serverIdBytes);
    }

    private static JSONObject _createRequest(String orderUuid, String productEntryName, int maxServers) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("version", 1);
        jsonObject.put("orderUuid", orderUuid);
        jsonObject.put("liferayVersion", ReleaseInfo.getBuildNumber());
        if (Validator.isNull((String)productEntryName)) {
            jsonObject.put("cmd", "QUERY");
        } else {
            jsonObject.put("cmd", "REGISTER");
            if (productEntryName.startsWith("basic")) {
                String[] productNameArray;
                jsonObject.put("productEntryName", "basic");
                if (productEntryName.equals("basic-cluster")) {
                    jsonObject.put("cluster", true);
                    jsonObject.put("maxServers", maxServers);
                } else if (productEntryName.startsWith("basic-") && (productNameArray = StringUtil.split((String)productEntryName, (String)"-")).length >= 3) {
                    jsonObject.put("offeringEntryId", productNameArray[1]);
                    jsonObject.put("clusterId", productNameArray[2]);
                }
            } else {
                jsonObject.put("productEntryName", productEntryName);
            }
            jsonObject.put("hostName", LicenseUtil.getHostName());
            jsonObject.put("ipAddresses", StringUtil.merge(LicenseUtil.getIpAddresses()));
            jsonObject.put("macAddresses", StringUtil.merge(LicenseUtil.getMacAddresses()));
            jsonObject.put("serverId", LicenseManager.getServerId());
        }
        return jsonObject;
    }

    private static String _decryptResponse(String serverURL, InputStream inputStream) throws Exception {
        if (serverURL.startsWith("https")) {
            return StringUtil.read((InputStream)inputStream);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        bytes = Encryptor.decryptUnencodedAsBytes((Key)_symmetricKey, (byte[])bytes);
        return new String(bytes, "UTF-8");
    }

    private static byte[] _encryptRequest(String serverURL, String request) throws Exception {
        byte[] bytes = request.getBytes("UTF-8");
        if (serverURL.startsWith("https")) {
            return bytes;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        bytes = Encryptor.encryptUnencoded((Key)_symmetricKey, (byte[])bytes);
        jsonObject.put("content", Base64.objectToString((Object)bytes));
        jsonObject.put("key", _encryptedSymmetricKey);
        return jsonObject.toString().getBytes("UTF-8");
    }

    private static Map<String, String> _getOrderProducts(JSONObject jsonObject) {
        JSONObject productsJSONObject = jsonObject.getJSONObject("productsJSONObject");
        if (productsJSONObject == null) {
            return null;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator itr = productsJSONObject.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            sortedMap.put(key, productsJSONObject.getString(key));
        }
        return sortedMap;
    }

    private static void _initKeys() {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        if (classLoader == null || _encryptedSymmetricKey != null) {
            return;
        }
        try {
            URL url = classLoader.getResource("com/liferay/portal/license/public.key");
            byte[] bytes = IOUtils.toByteArray((InputStream)url.openStream());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128, new SecureRandom());
            _symmetricKey = keyGenerator.generateKey();
            byte[] encryptedSymmetricKey = Encryptor.encryptUnencoded((Key)publicKey, (byte[])_symmetricKey.getEncoded());
            _encryptedSymmetricKey = Base64.objectToString((Object)encryptedSymmetricKey);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    private static void _registerClusterOrder(HttpServletRequest request, ClusterNode clusterNode, String orderUuid, String productEntryName, int maxServers) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_registerOrderMethodKey, new Object[]{orderUuid, productEntryName, maxServers});
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (String[])new String[]{clusterNode.getClusterNodeId()});
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
        ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode);
        Map attributes = (Map)clusterNodeResponse.getResult();
        for (Map.Entry entry : attributes.entrySet()) {
            request.setAttribute(String.valueOf(clusterNode.getClusterNodeId()) + "_" + (String)entry.getKey(), entry.getValue());
        }
    }
}

