/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.velocity.ColumnProcessor;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateProcessor
implements ColumnProcessor {
    private Portlet _portlet;
    private boolean _portletAjaxRender;
    private Map<Integer, List<PortletRenderer>> _portletRenderers;
    private HttpServletRequest _request;
    private HttpServletResponse _response;

    public TemplateProcessor(HttpServletRequest request, HttpServletResponse response, String portletId) throws SystemException {
        this._request = request;
        this._response = response;
        if (Validator.isNotNull((String)portletId)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        }
        this._portletAjaxRender = GetterUtil.getBoolean((Object)request.getAttribute("PORTLET_AJAX_RENDER"));
        this._portletRenderers = new TreeMap<Integer, List<PortletRenderer>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer renderWeight1, Integer renderWeight2) {
                return renderWeight2.compareTo(renderWeight1);
            }
        });
    }

    public Map<Integer, List<PortletRenderer>> getPortletRenderers() {
        return this._portletRenderers;
    }

    public boolean isPortletAjaxRender() {
        return this._portletAjaxRender;
    }

    @Override
    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    @Override
    public String processColumn(String columnId, String classNames) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        List portlets = layoutTypePortlet.getAllPortlets(columnId);
        StringBundler sb = new StringBundler(portlets.size() + 11);
        sb.append("<div class=\"");
        sb.append("portlet-dropzone");
        if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isColumnDisabled(columnId)) {
            sb.append(" portlet-dropzone-disabled");
        }
        if (layoutTypePortlet.isColumnCustomizable(columnId)) {
            sb.append(" customizable");
        }
        if (portlets.isEmpty()) {
            sb.append(" empty");
        }
        if (Validator.isNotNull((String)classNames)) {
            sb.append(" ");
            sb.append(classNames);
        }
        sb.append("\" id=\"layout-column_");
        sb.append(columnId);
        sb.append("\">");
        int i2 = 0;
        while (i2 < portlets.size()) {
            Portlet portlet = (Portlet)portlets.get(i2);
            Integer columnCount = new Integer(portlets.size());
            Integer columnPos = new Integer(i2);
            PortletRenderer portletRenderer = new PortletRenderer(portlet, columnId, columnCount, columnPos);
            if (this._portletAjaxRender && portlet.getRenderWeight() < 1) {
                StringBundler renderResult = portletRenderer.renderAjax(this._request, this._response);
                sb.append(renderResult);
            } else {
                Integer renderWeight = portlet.getRenderWeight();
                List<PortletRenderer> portletRenderers = this._portletRenderers.get(renderWeight);
                if (portletRenderers == null) {
                    portletRenderers = new ArrayList<PortletRenderer>();
                    this._portletRenderers.put(renderWeight, portletRenderers);
                }
                portletRenderers.add(portletRenderer);
                sb.append("[$TEMPLATE_PORTLET_");
                sb.append(portlet.getPortletId());
                sb.append("$]");
            }
            ++i2;
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    public String processMax() throws Exception {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._response);
        PortletContainerUtil.render((HttpServletRequest)this._request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
        return bufferCacheServletResponse.getString();
    }

    @Override
    public String processPortlet(String portletId) throws Exception {
        this._request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._response);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        try {
            PortletContainerUtil.render((HttpServletRequest)this._request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)portlet);
            String string = bufferCacheServletResponse.getString();
            return string;
        }
        finally {
            this._request.removeAttribute("RENDER_PORTLET_RESOURCE");
        }
    }
}

