/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchLayoutPrototypeException;
import com.liferay.portal.NoSuchLayoutSetPrototypeException;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

public class LayoutImporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutImporter.class);
    private static MethodHandler _loadThemesMethodHandler = new MethodHandler(new MethodKey(ThemeLoaderFactory.class, "loadThemes", new Class[0]), new Object[0]);
    private Element _headerElement;
    private List<Element> _layoutElements;
    private Element _layoutsElement;
    private PermissionImporter _permissionImporter = new PermissionImporter();
    private PortletImporter _portletImporter = new PortletImporter();
    private Element _rootElement;

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            this.doImportLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        finally {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    public void validateFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layoutSet.getCompanyId(), (long)groupId, parameterMap, null, (ZipReader)zipReader);
        this.validateFile(portletDataContext);
        Map missingReferences = ExportImportHelperUtil.validateMissingReferences((long)userId, (long)groupId, parameterMap, (File)file);
        if (!missingReferences.isEmpty()) {
            throw new MissingReferenceException(missingReferences);
        }
    }

    protected void deleteMissingLayouts(long groupId, boolean privateLayout, List<Layout> newLayouts, List<Layout> previousLayouts, ServiceContext serviceContext) throws Exception {
        HashSet<String> existingLayoutUuids = new HashSet<String>();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.hasStagingGroup()) {
            Group stagingGroup = group.getStagingGroup();
            if (stagingGroup.hasPrivateLayouts() || stagingGroup.hasPublicLayouts()) {
                List layouts = LayoutLocalServiceUtil.getLayouts((long)stagingGroup.getGroupId(), (boolean)privateLayout);
                for (Layout layout : layouts) {
                    existingLayoutUuids.add(layout.getUuid());
                }
            }
        } else {
            for (Layout layout : newLayouts) {
                existingLayoutUuids.add(layout.getUuid());
            }
        }
        if (_log.isDebugEnabled() && !existingLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        for (Layout layout : previousLayouts) {
            if (existingLayoutUuids.contains(layout.getUuid())) continue;
            try {
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)privateLayout, (ServiceContext)serviceContext);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
    }

    protected void doImportLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        UnicodeProperties settingsProperties;
        String mergeFailFriendlyURLLayouts;
        boolean deleteMissingLayouts = MapUtil.getBoolean(parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean importTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        boolean importThemeSettings = MapUtil.getBoolean(parameterMap, (String)"THEME_REFERENCE");
        boolean importLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean importLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED", (boolean)true);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayoutSetPrototype()) {
            layoutSetPrototypeLinkEnabled = false;
        }
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete portlet data " + deletePortletData));
            _log.debug((Object)("Import categories " + importCategories));
            _log.debug((Object)("Import permissions " + importPermissions));
            _log.debug((Object)("Import portlet data " + importPortletData));
            _log.debug((Object)("Import portlet setup " + importPortletSetup));
            _log.debug((Object)("Import portlet archived setups " + importPortletArchivedSetups));
            _log.debug((Object)("Import portlet user preferences " + importPortletUserPreferences));
            _log.debug((Object)("Import theme " + importTheme));
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy strategy = this._portletImporter.getUserIdStrategy(user, userIdStrategy);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)companyId, (long)groupId, parameterMap, (UserIdStrategy)strategy, (ZipReader)zipReader);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPrivateLayout(privateLayout);
        InputStream themeZip = null;
        this.validateFile(portletDataContext);
        long sourceCompanyId = GetterUtil.getLong((String)this._headerElement.attributeValue("company-id"));
        portletDataContext.setSourceCompanyId(sourceCompanyId);
        long sourceCompanyGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("company-group-id"));
        portletDataContext.setSourceCompanyGroupId(sourceCompanyGroupId);
        long sourceGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("group-id"));
        portletDataContext.setSourceGroupId(sourceGroupId);
        long sourceUserPersonalSiteGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("user-personal-site-group-id"));
        portletDataContext.setSourceUserPersonalSiteGroupId(sourceUserPersonalSiteGroupId);
        String layoutSetPrototypeUuid = this._layoutsElement.attributeValue("layout-set-prototype-uuid");
        String larType = this._headerElement.attributeValue("type");
        if (group.isLayoutPrototype() && larType.equals("layout-prototype")) {
            deleteMissingLayouts = false;
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            String layoutPrototypeUuid = GetterUtil.getString((String)this._headerElement.attributeValue("type-uuid"));
            LayoutPrototype existingLayoutPrototype = null;
            if (Validator.isNotNull((String)layoutPrototypeUuid)) {
                try {
                    existingLayoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)companyId);
                }
                catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {}
            }
            if (existingLayoutPrototype == null) {
                List layouts = LayoutLocalServiceUtil.getLayoutsByLayoutPrototypeUuid((String)layoutPrototype.getUuid());
                layoutPrototype.setUuid(layoutPrototypeUuid);
                LayoutPrototypeLocalServiceUtil.updateLayoutPrototype((LayoutPrototype)layoutPrototype);
                for (Layout layout : layouts) {
                    layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
                    LayoutLocalServiceUtil.updateLayout((Layout)layout);
                }
            }
        } else if (group.isLayoutSetPrototype() && larType.equals("layout-set-prototype")) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            String importedLayoutSetPrototypeUuid = GetterUtil.getString((String)this._headerElement.attributeValue("type-uuid"));
            LayoutSetPrototype existingLayoutSetPrototype = null;
            if (Validator.isNotNull((String)importedLayoutSetPrototypeUuid)) {
                try {
                    existingLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)importedLayoutSetPrototypeUuid, (long)companyId);
                }
                catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {}
            }
            if (existingLayoutSetPrototype == null) {
                layoutSetPrototype.setUuid(importedLayoutSetPrototypeUuid);
                LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
            }
        } else if (larType.equals("layout-set-prototype")) {
            layoutSetPrototypeUuid = GetterUtil.getString((String)this._headerElement.attributeValue("type-uuid"));
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        if (importTheme) {
            themeZip = portletDataContext.getZipEntryAsInputStream("theme.zip");
        }
        String themeId = layoutSet.getThemeId();
        String colorSchemeId = layoutSet.getColorSchemeId();
        if (importThemeSettings) {
            Attribute colorSchemeIdAttribute;
            Attribute themeIdAttribute = this._headerElement.attribute("theme-id");
            if (themeIdAttribute != null) {
                themeId = themeIdAttribute.getValue();
            }
            if ((colorSchemeIdAttribute = this._headerElement.attribute("color-scheme-id")) != null) {
                colorSchemeId = colorSchemeIdAttribute.getValue();
            }
        }
        if (importLogo) {
            String logoPath = this._headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            if (iconBytes != null && iconBytes.length > 0) {
                File logo = null;
                try {
                    logo = FileUtil.createTempFile((byte[])iconBytes);
                    LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)true, (File)logo);
                }
                finally {
                    FileUtil.delete((File)logo);
                }
            } else {
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)false, null);
            }
        }
        if (importLayoutSetSettings) {
            String settings = GetterUtil.getString((String)this._headerElement.elementText("settings"));
            LayoutSetLocalServiceUtil.updateSettings((long)groupId, (boolean)privateLayout, (String)settings);
        }
        String css = GetterUtil.getString((String)this._headerElement.elementText("css"));
        if (themeZip != null) {
            String importThemeId = this.importTheme(layoutSet, themeZip);
            if (importThemeId != null) {
                themeId = importThemeId;
                colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing theme takes " + stopWatch.getTime() + " ms"));
            }
        }
        boolean wapTheme = false;
        LayoutSetLocalServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (String)themeId, (String)colorSchemeId, (String)css, (boolean)wapTheme);
        if (importPermissions) {
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        this._portletImporter.readAssetCategories(portletDataContext);
        this._portletImporter.readAssetTags(portletDataContext);
        this._portletImporter.readComments(portletDataContext);
        this._portletImporter.readExpandoTables(portletDataContext);
        this._portletImporter.readLocks(portletDataContext);
        this._portletImporter.readRatingsEntries(portletDataContext);
        List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            for (Layout layout : previousLayouts) {
                Layout sourcePrototypeLayout;
                String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) || (sourcePrototypeLayout = LayoutUtil.fetchByUUID_G_P((String)sourcePrototypeLayoutUuid, (long)layoutSetPrototype.getGroupId(), (boolean)true)) != null) continue;
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
        }
        ArrayList<Layout> newLayouts = new ArrayList<Layout>();
        if (_log.isDebugEnabled() && this._layoutElements.size() > 0) {
            _log.debug((Object)"Importing layouts");
        }
        for (Element layoutElement : this._layoutElements) {
            this.importLayout(portletDataContext, newLayouts, layoutElement);
        }
        Element portletsElement = this._rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        Map newLayoutsMap = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        if (deletePortletData) {
            if (_log.isDebugEnabled() && portletElements.size() > 0) {
                _log.debug((Object)"Deleting portlet data");
            }
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
                Layout layout = (Layout)newLayoutsMap.get(layoutId);
                long plid = layout.getPlid();
                portletDataContext.setPlid(plid);
                this._portletImporter.deletePortletData(portletDataContext, portletId, plid);
            }
        }
        if (_log.isDebugEnabled() && portletElements.size() > 0) {
            _log.debug((Object)"Importing portlets");
        }
        for (Element portletElement : portletElements) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            Layout layout = (Layout)newLayoutsMap.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                plid = layout.getPlid();
            }
            if ((layout = LayoutUtil.fetchByPrimaryKey((long)plid)) == null && !group.isCompany()) continue;
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(oldPlid);
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this._portletImporter.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = groupId;
            Element portletDataElement = portletElement.element("portlet-data");
            boolean importData = importPortletData && portletDataElement != null;
            try {
                if (layout != null && !group.isCompany()) {
                    portletPreferencesGroupId = layout.getGroupId();
                }
                this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), portletPreferencesGroupId, layout, null, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false, importData);
                if (importData) {
                    this._portletImporter.importPortletData(portletDataContext, portletId, plid, portletDataElement);
                }
            }
            finally {
                this._portletImporter.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (importPermissions) {
                this._permissionImporter.importPortletPermissions(layoutCache, companyId, groupId, userId, layout, portletElement, portletId);
            }
            this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), groupId, null, null, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false, importData);
        }
        if (importPermissions && userId > 0L) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)userId);
        }
        this._portletImporter.readAssetLinks(portletDataContext);
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(groupId, privateLayout, newLayouts, previousLayouts, serviceContext);
        }
        layoutSet = LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        GroupLocalServiceUtil.updateSite((long)groupId, (boolean)true);
        long lastMergeTime = System.currentTimeMillis();
        for (Layout layout : newLayouts) {
            boolean modifiedTypeSettingsProperties = false;
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id");
            if (Validator.isNotNull((String)articleId)) {
                Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
                typeSettingsProperties.setProperty("article-id", MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId));
                modifiedTypeSettingsProperties = true;
            }
            if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                typeSettingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
                modifiedTypeSettingsProperties = true;
            }
            if (!modifiedTypeSettingsProperties) continue;
            LayoutUtil.update((Layout)layout);
        }
        if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE") && Validator.isNull((String)(mergeFailFriendlyURLLayouts = (settingsProperties = layoutSet.getSettingsProperties()).getProperty("merge-fail-friendly-url-layouts")))) {
            settingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        zipReader.close();
    }

    protected void importLayout(PortletDataContext portletDataContext, List<Layout> newLayouts, Element layoutElement) throws Exception {
        String path = layoutElement.attributeValue("path");
        Layout layout = (Layout)portletDataContext.getZipEntryAsObject(path);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout);
        List portletDataContextNewLayouts = portletDataContext.getNewLayouts();
        newLayouts.addAll(portletDataContextNewLayouts);
        portletDataContextNewLayouts.clear();
    }

    protected String importTheme(LayoutSet layoutSet, InputStream themeZip) throws Exception {
        ThemeLoader themeLoader = ThemeLoaderFactory.getDefaultThemeLoader();
        if (themeLoader == null) {
            _log.error((Object)"No theme loaders are deployed");
            return null;
        }
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)themeZip);
        String lookAndFeelXML = zipReader.getEntryAsString("liferay-look-and-feel.xml");
        String themeId = String.valueOf(layoutSet.getGroupId());
        themeId = layoutSet.isPrivateLayout() ? String.valueOf(themeId) + "-private" : String.valueOf(themeId) + "-public";
        if (PropsValues.THEME_LOADER_NEW_THEME_ID_ON_IMPORT) {
            Date now = new Date();
            themeId = String.valueOf(themeId) + "-" + Time.getShortTimestamp((Date)now);
        }
        String themeName = themeId;
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$GROUP_ID$]", "[$THEME_ID$]", "[$THEME_NAME$]"}, (String[])new String[]{String.valueOf(layoutSet.getGroupId()), themeId, themeName});
        FileUtil.deltree((String)(themeLoader.getFileStorage() + "/" + themeId));
        List zipEntries = zipReader.getEntries();
        for (String zipEntry : zipEntries) {
            String key = zipEntry;
            if (key.equals("liferay-look-and-feel.xml")) {
                FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (byte[])lookAndFeelXML.getBytes());
                continue;
            }
            InputStream is = zipReader.getEntryAsInputStream(zipEntry);
            FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (InputStream)is);
        }
        themeLoader.loadThemes();
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)_loadThemesMethodHandler, (boolean)true);
        clusterRequest.setFireAndForget(true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        themeId = String.valueOf(themeId) + "_WAR_" + themeLoader.getServletContextName();
        return PortalUtil.getJsSafePortletId((String)themeId);
    }

    protected void readXML(PortletDataContext portletDataContext) throws Exception {
        if (this._rootElement != null && this._headerElement != null && this._layoutsElement != null && this._layoutElements != null) {
            return;
        }
        String xml = portletDataContext.getZipEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            this._rootElement = document.getRootElement();
            portletDataContext.setImportDataRootElement(this._rootElement);
        }
        catch (Exception e2) {
            throw new LARFileException((Throwable)e2);
        }
        this._headerElement = this._rootElement.element("header");
        this._layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        this._layoutElements = this._layoutsElement.elements();
    }

    protected void validateFile(PortletDataContext portletDataContext) throws Exception {
        this.readXML(portletDataContext);
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)this._headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = this._headerElement.attributeValue("type");
        if (!(larType.equals("layout-prototype") || larType.equals("layout-set") || larType.equals("layout-set-prototype"))) {
            throw new LARTypeException(larType);
        }
        Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)this._headerElement.attributeValue("available-locales")));
        Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales();
        Locale[] localeArray = sourceAvailableLocales;
        int n = sourceAvailableLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale sourceAvailableLocale = localeArray[n2];
            if (!ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) {
                LocaleException le = new LocaleException();
                le.setSourceAvailableLocales(sourceAvailableLocales);
                le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
                throw le;
            }
            ++n2;
        }
        this.validateLayoutPrototypes(portletDataContext.getCompanyId(), this._layoutsElement, this._layoutElements);
    }

    protected void validateLayoutPrototypes(long companyId, Element layoutsElement, List<Element> layoutElements) throws Exception {
        ArrayList<Tuple> missingLayoutPrototypes = new ArrayList<Tuple>();
        String layoutSetPrototypeUuid = layoutsElement.attributeValue("layout-set-prototype-uuid");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            try {
                LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            }
            catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {
                String layoutSetPrototypeName = layoutsElement.attributeValue("layout-set-prototype-name");
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutSetPrototype.class.getName(), layoutSetPrototypeUuid, layoutSetPrototypeName}));
            }
        }
        for (Element layoutElement : layoutElements) {
            String layoutPrototypeUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-uuid"));
            if (!Validator.isNotNull((String)layoutPrototypeUuid)) continue;
            try {
                LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)companyId);
            }
            catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {
                String layoutPrototypeName = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-name"));
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
            }
        }
        if (!missingLayoutPrototypes.isEmpty()) {
            throw new LayoutPrototypeException(missingLayoutPrototypes);
        }
    }
}

