/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventExporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.StopWatch;

public class LayoutExporter {
    public static final String SAME_GROUP_FRIENDLY_URL = "/[$SAME_GROUP_FRIENDLY_URL$]";
    private static Log _log = LogFactoryUtil.getLog(LayoutExporter.class);
    private DeletionSystemEventExporter _deletionSystemEventExporter = new DeletionSystemEventExporter();
    private PermissionExporter _permissionExporter = new PermissionExporter();
    private PortletExporter _portletExporter = new PortletExporter();

    public static List<Portlet> getDataSiteLevelPortlets(long companyId) throws Exception {
        List portlets = PortletLocalServiceUtil.getPortlets((long)companyId);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (!portlet.isActive()) {
                itr.remove();
                continue;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler != null && portletDataHandler.isDataSiteLevel()) continue;
            itr.remove();
        }
        return portlets;
    }

    public static List<Portlet> getPortletDataHandlerPortlets(List<Layout> layouts) throws SystemException {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        HashSet<String> rootPortletIds = new HashSet<String>();
        for (Layout curLayout : layouts) {
            if (!curLayout.isTypePortlet()) continue;
            LayoutTypePortlet curLayoutTypePortlet = (LayoutTypePortlet)curLayout.getLayoutType();
            for (String portletId : curLayoutTypePortlet.getPortletIds()) {
                PortletDataHandler portletDataHandler;
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)curLayout.getCompanyId(), (String)portletId);
                if (portlet == null || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || rootPortletIds.contains(portlet.getRootPortletId())) continue;
                rootPortletIds.add(portlet.getRootPortletId());
                portlets.add(portlet);
            }
        }
        return portlets;
    }

    public static List<Portlet> getPortletDataHandlerPortlets(long groupId, boolean privateLayout) throws SystemException {
        return LayoutExporter.getPortletDataHandlerPortlets(LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout));
    }

    public static void updateLastPublishDate(LayoutSet layoutSet, long lastPublishDate) throws Exception {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        if (lastPublishDate <= 0L) {
            settingsProperties.remove((Object)"last-publish-date");
        } else {
            settingsProperties.setProperty("last-publish-date", String.valueOf(lastPublishDate));
        }
        LayoutSetLocalServiceUtil.updateSettings((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (String)settingsProperties.toString());
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        finally {
            file.delete();
        }
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)true);
            File file = this.doExportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
        }
    }

    protected File doExportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        Image image;
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportIgnoreLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        boolean exportThemeSettings = MapUtil.getBoolean(parameterMap, (String)"THEME_REFERENCE");
        boolean exportLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean exportLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean updateLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export theme " + exportTheme));
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        serviceContext.setAttribute("exporting", (Serializable)Boolean.TRUE);
        long layoutSetBranchId = MapUtil.getLong(parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        long lastPublishDate = System.currentTimeMillis();
        if (endDate != null) {
            lastPublishDate = endDate.getTime();
        }
        if (exportIgnoreLastPublishDate) {
            endDate = null;
            startDate = null;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)companyId, (long)groupId, parameterMap, (Date)startDate, (Date)endDate, (ZipWriter)zipWriter);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales()));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(groupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(privateLayout));
        Group group = layoutSet.getGroup();
        String type = "layout-set";
        if (group.isLayoutPrototype()) {
            type = "layout-prototype";
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutPrototype.getUuid());
        } else if (group.isLayoutSetPrototype()) {
            type = "layout-set-prototype";
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutSetPrototype.getUuid());
        }
        headerElement.addAttribute("type", type);
        if (exportTheme || exportThemeSettings) {
            headerElement.addAttribute("theme-id", layoutSet.getThemeId());
            headerElement.addAttribute("color-scheme-id", layoutSet.getColorSchemeId());
        }
        if (exportLogo && (image = ImageLocalServiceUtil.getImage((long)layoutSet.getLogoId())) != null && image.getTextObj() != null) {
            String logoPath = ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext);
            logoPath = String.valueOf(logoPath) + "/logo";
            headerElement.addAttribute("logo-path", logoPath);
            portletDataContext.addZipEntry(logoPath, image.getTextObj());
        }
        if (exportLayoutSetSettings) {
            Element settingsElement = headerElement.addElement("settings");
            settingsElement.addCDATA(layoutSet.getSettings());
        }
        Element cssElement = headerElement.addElement("css");
        cssElement.addCDATA(layoutSet.getCss());
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = null;
        layouts = layoutIds == null || layoutIds.length == 0 ? LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout) : LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long[])layoutIds);
        List<Portlet> portlets = LayoutExporter.getDataSiteLevelPortlets(companyId);
        long plid = 0L;
        if (!layouts.isEmpty()) {
            Layout firstLayout = (Layout)layouts.get(0);
            plid = firstLayout.getPlid();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        for (Portlet portlet : portlets) {
            String key;
            String portletId = portlet.getRootPortletId();
            if (!group.isStagedPortlet(portletId) || portletIds.get(key = PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId)) != null) continue;
            portletIds.put(key, new Object[]{portletId, plid, groupId, "", ""});
        }
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        Element layoutsElement = portletDataContext.getExportDataGroupElement(Layout.class);
        String layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            layoutsElement.addAttribute("layout-set-prototype-uuid", layoutSetPrototypeUuid);
            layoutsElement.addAttribute("layout-set-prototype-name", layoutSetPrototype.getName(LocaleUtil.getDefault()));
        }
        for (Layout layout : layouts) {
            this.exportLayout(portletDataContext, portlets, portletIds, layout, layoutsElement);
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        Element portletsElement = rootElement.addElement("portlets");
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            Object[] portletObjects = (Object[])portletIdsEntry.getValue();
            String portletId = null;
            plid = 0L;
            long scopeGroupId = 0L;
            String scopeType = "";
            String scopeLayoutUuid = null;
            if (portletObjects.length == 4) {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[3];
            } else {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeType = (String)((Object[])portletIdsEntry.getValue())[3];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[4];
            }
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
            if (layout == null) {
                if (!group.isCompany() && plid <= 0L) continue;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Assuming global scope because no layout was found");
                }
                layout = new LayoutImpl();
                layout.setGroupId(groupId);
                layout.setCompanyId(companyId);
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(plid);
            portletDataContext.setScopeGroupId(scopeGroupId);
            portletDataContext.setScopeType(scopeType);
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            boolean[] exportPortletControls = this.getExportPortletControls(companyId, portletId, parameterMap, type);
            this._portletExporter.exportPortlet(portletDataContext, layoutCache, portletId, layout, portletsElement, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletControls[0], exportPortletControls[1], exportPortletUserPreferences);
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        this.exportAssetCategories(portletDataContext, exportPortletDataAll, exportCategories, group.isCompany());
        this._portletExporter.exportAssetLinks(portletDataContext);
        this._portletExporter.exportAssetTags(portletDataContext);
        this._portletExporter.exportComments(portletDataContext);
        this._portletExporter.exportExpandoTables(portletDataContext);
        this._portletExporter.exportLocks(portletDataContext);
        this._deletionSystemEventExporter.export(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this._portletExporter.exportRatingsEntries(portletDataContext, rootElement);
        if (exportTheme && !portletDataContext.isPerformDirectBinaryImport()) {
            this.exportTheme(layoutSet, zipWriter);
        }
        ExportImportHelperUtil.writeManifestSummary((Document)document, (ManifestSummary)portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            if (stopWatch != null) {
                _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
            } else {
                _log.info((Object)"Exporting layouts is finished");
            }
        }
        portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        try {
            File file = zipWriter.getFile();
            return file;
        }
        finally {
            if (updateLastPublishDate) {
                LayoutExporter.updateLastPublishDate(layoutSet, lastPublishDate);
            }
        }
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext, boolean exportPortletDataAll, boolean exportCategories, boolean companyGroup) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("categories-hierarchy");
        if (exportPortletDataAll || exportCategories || companyGroup) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Export categories");
            }
            Element assetVocabulariesElement = rootElement.addElement("vocabularies");
            List assetVocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)portletDataContext.getGroupId());
            for (AssetVocabulary assetVocabulary : assetVocabularies) {
                this._portletExporter.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetVocabulary);
            }
            Element categoriesElement = rootElement.addElement("categories");
            List assetCategories = AssetCategoryUtil.findByGroupId((long)portletDataContext.getGroupId());
            for (AssetCategory assetCategory : assetCategories) {
                this._portletExporter.exportAssetCategory(portletDataContext, assetVocabulariesElement, categoriesElement, assetCategory);
            }
        }
        this._portletExporter.exportAssetCategories(portletDataContext, rootElement);
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/categories-hierarchy.xml", document.formattedString());
    }

    protected void exportLayout(PortletDataContext portletDataContext, List<Portlet> portlets, Map<String, Object[]> portletIds, Layout layout, Element layoutsElement) throws Exception {
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout);
        if (!layout.isSupportsEmbeddedPortlets()) {
            return;
        }
        if (layout.isTypePortlet()) {
            for (Portlet portlet : portlets) {
                if (!portlet.isScopeable() || !layout.hasScopeGroup()) continue;
                String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId());
                Group scopeGroup = layout.getScopeGroup();
                portletIds.put(key, new Object[]{portlet.getPortletId(), layout.getPlid(), scopeGroup.getGroupId(), "", layout.getUuid()});
            }
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets()) {
            String portletId = portlet.getPortletId();
            PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            String scopeType = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeType", null));
            String scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeLayoutUuid", null));
            long scopeGroupId = portletDataContext.getScopeGroupId();
            if (Validator.isNotNull((String)scopeType)) {
                Group scopeGroup = null;
                if (scopeType.equals("company")) {
                    scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
                } else if (scopeType.equals("layout")) {
                    Layout scopeLayout = null;
                    scopeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout());
                    if (scopeLayout == null) continue;
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
                }
                if (scopeGroup != null) {
                    scopeGroupId = scopeGroup.getGroupId();
                }
            }
            String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeType, scopeLayoutUuid});
        }
    }

    protected void exportTheme(LayoutSet layoutSet, ZipWriter zipWriter) throws Exception {
        Theme theme = layoutSet.getTheme();
        String lookAndFeelXML = ContentUtil.get((String)"com/liferay/portal/dependencies/liferay-look-and-feel.xml.tmpl");
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$TEMPLATE_EXTENSION$]", "[$VIRTUAL_PATH$]"}, (String[])new String[]{theme.getTemplateExtension(), theme.getVirtualPath()});
        String servletContextName = theme.getServletContextName();
        ServletContext servletContext = ServletContextPool.get((String)servletContextName);
        if (servletContext == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Servlet context not found for theme " + theme.getThemeId()));
            }
            return;
        }
        File themeZip = new File(String.valueOf(zipWriter.getPath()) + "/theme.zip");
        ZipWriter themeZipWriter = ZipWriterFactoryUtil.getZipWriter((File)themeZip);
        themeZipWriter.addEntry("liferay-look-and-feel.xml", lookAndFeelXML);
        File cssPath = null;
        File imagesPath = null;
        File javaScriptPath = null;
        File templatesPath = null;
        if (!theme.isLoadFromServletContext()) {
            ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(servletContextName);
            if (themeLoader == null) {
                _log.error((Object)(String.valueOf(servletContextName) + " does not map to a theme loader"));
            } else {
                File file = themeLoader.getFileStorage();
                String realPath = String.valueOf(file.getPath()) + "/" + theme.getName();
                cssPath = new File(String.valueOf(realPath) + "/css");
                imagesPath = new File(String.valueOf(realPath) + "/images");
                javaScriptPath = new File(String.valueOf(realPath) + "/javascript");
                templatesPath = new File(String.valueOf(realPath) + "/templates");
            }
        } else {
            cssPath = new File(servletContext.getRealPath(theme.getCssPath()));
            imagesPath = new File(servletContext.getRealPath(theme.getImagesPath()));
            javaScriptPath = new File(servletContext.getRealPath(theme.getJavaScriptPath()));
            templatesPath = new File(servletContext.getRealPath(theme.getTemplatesPath()));
        }
        this.exportThemeFiles("css", cssPath, themeZipWriter);
        this.exportThemeFiles("images", imagesPath, themeZipWriter);
        this.exportThemeFiles("javascript", javaScriptPath, themeZipWriter);
        this.exportThemeFiles("templates", templatesPath, themeZipWriter);
    }

    protected void exportThemeFiles(String path, File dir, ZipWriter zipWriter) throws Exception {
        File[] files;
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.exportThemeFiles(String.valueOf(path) + "/" + file.getName(), file, zipWriter);
            } else {
                zipWriter.addEntry(String.valueOf(path) + "/" + file.getName(), FileUtil.getBytes((File)file));
            }
            ++n2;
        }
    }

    protected boolean[] getExportPortletControls(long companyId, String portletId, Map<String, String[]> parameterMap, String type) throws Exception {
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean exportPortletSetupAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
        }
        boolean exportCurPortletData = exportPortletData;
        boolean exportCurPortletSetup = exportPortletSetup;
        if (exportPortletDataAll) {
            exportCurPortletData = true;
            exportCurPortletSetup = true;
        } else {
            String portletDataHandlerClass;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            if (portlet != null && (portletDataHandlerClass = portlet.getPortletDataHandlerClass()) != null) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                exportCurPortletData = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + rootPortletId));
                boolean bl = exportCurPortletSetup = exportPortletSetup && MapUtil.getBoolean(parameterMap, (String)("PORTLET_SETUP_" + rootPortletId));
            }
        }
        if (exportPortletSetupAll || exportPortletSetup && type.equals("layout-prototype")) {
            exportCurPortletSetup = true;
        }
        return new boolean[]{exportCurPortletData, exportCurPortletSetup};
    }

    protected String getLayoutIconPath(PortletDataContext portletDataContext, Layout layout, Image image) {
        StringBundler sb = new StringBundler(5);
        sb.append(ExportImportPathUtil.getLayoutPath((PortletDataContext)portletDataContext, (long)layout.getPlid()));
        sb.append("/icons/");
        sb.append(image.getImageId());
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }

    protected String getLayoutSetPrototype(PortletDataContext portletDataContext, String layoutSetPrototypeUuid) {
        StringBundler sb = new StringBundler(3);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/layout-set-prototype/");
        sb.append(layoutSetPrototypeUuid);
        return sb.toString();
    }
}

