/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutCache {
    protected Map<String, Long> entityGroupIdMap = new HashMap<String, Long>();
    protected Map<String, Map<String, Long>> entityMapMap = new HashMap<String, Map<String, Long>>();
    protected Map<Long, List<Role>> groupRolesMap = new HashMap<Long, List<Role>>();
    protected Map<Long, List<User>> groupUsersMap = new HashMap<Long, List<User>>();
    protected Map<String, Role> rolesMap = new HashMap<String, Role>();
    protected Map<Long, List<Role>> userRolesMap = new HashMap<Long, List<Role>>();

    protected long getEntityGroupId(long companyId, String entityName, String name) throws PortalException, SystemException {
        long entityGroupId = 0L;
        Long entityGroupIdObj = this.entityGroupIdMap.get(entityName);
        if (entityGroupIdObj == null) {
            List organizations;
            if (entityName.equals("user-group")) {
                List userGroups = UserGroupLocalServiceUtil.search((long)companyId, null, null, (int)0, (int)1, null);
                if (userGroups.size() > 0) {
                    UserGroup userGroup = (UserGroup)userGroups.get(0);
                    Group group = userGroup.getGroup();
                    entityGroupId = group.getGroupId();
                }
            } else if (entityName.equals("organization") && (organizations = OrganizationLocalServiceUtil.search((long)companyId, (long)-1L, (String)name, null, null, null, null, null, null, null, (boolean)true, (int)0, (int)1)).size() > 0) {
                Organization organization = (Organization)organizations.get(0);
                Group group = organization.getGroup();
                entityGroupId = group.getGroupId();
            }
            this.entityGroupIdMap.put(entityName, entityGroupId);
        } else {
            entityGroupId = entityGroupIdObj;
        }
        return entityGroupId;
    }

    protected Map<String, Long> getEntityMap(long companyId, String entityName) throws PortalException, SystemException {
        Map<String, Long> entityMap = this.entityMapMap.get(entityName);
        if (entityMap != null) {
            return entityMap;
        }
        entityMap = new HashMap<String, Long>();
        if (entityName.equals("user-group")) {
            List userGroups = UserGroupLocalServiceUtil.search((long)companyId, null, null, (int)-1, (int)-1, null);
            int i2 = 0;
            while (i2 < userGroups.size()) {
                UserGroup userGroup = (UserGroup)userGroups.get(i2);
                Group group = userGroup.getGroup();
                entityMap.put(userGroup.getName(), group.getGroupId());
                ++i2;
            }
        } else if (entityName.equals("organization")) {
            List organizations = OrganizationLocalServiceUtil.search((long)companyId, (long)-1L, null, (String)"regular-organization", null, null, null, (int)-1, (int)-1);
            int i3 = 0;
            while (i3 < organizations.size()) {
                Organization organization = (Organization)organizations.get(i3);
                Group group = organization.getGroup();
                entityMap.put(organization.getName(), group.getGroupId());
                ++i3;
            }
        }
        this.entityMapMap.put(entityName, entityMap);
        return entityMap;
    }

    protected List<Role> getGroupRoles_1to4(long groupId) throws SystemException {
        List roles = this.groupRolesMap.get(groupId);
        if (roles == null) {
            roles = RoleLocalServiceUtil.getGroupRoles((long)groupId);
            this.groupRolesMap.put(groupId, roles);
        }
        return roles;
    }

    protected List<Role> getGroupRoles_5(long groupId, String resourceName) throws PortalException, SystemException {
        List roles = this.groupRolesMap.get(groupId);
        if (roles != null) {
            return roles;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        roles = ResourceActionsUtil.getRoles((long)group.getCompanyId(), (Group)group, (String)resourceName, null);
        List teams = TeamLocalServiceUtil.getGroupTeams((long)groupId);
        for (Team team : teams) {
            Role teamRole = RoleLocalServiceUtil.getTeamRole((long)group.getCompanyId(), (long)team.getTeamId());
            teamRole.setName("ROLE_TEAM_,*" + team.getName());
            teamRole.setDescription(team.getDescription());
            roles.add(teamRole);
        }
        this.groupRolesMap.put(groupId, roles);
        return roles;
    }

    protected List<User> getGroupUsers(long groupId) throws SystemException {
        List users = this.groupUsersMap.get(groupId);
        if (users == null) {
            users = UserLocalServiceUtil.getGroupUsers((long)groupId);
            this.groupUsersMap.put(groupId, users);
        }
        return users;
    }

    protected Role getRole(long companyId, String roleName) throws PortalException, SystemException {
        Role role = this.rolesMap.get(roleName);
        if (role == null) {
            try {
                role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
                this.rolesMap.put(roleName, role);
            }
            catch (NoSuchRoleException noSuchRoleException) {}
        }
        return role;
    }

    protected List<Role> getUserRoles(long userId) throws SystemException {
        List userRoles = this.userRolesMap.get(userId);
        if (userRoles == null) {
            userRoles = RoleLocalServiceUtil.getUserRoles((long)userId);
            this.userRolesMap.put(userId, userRoles);
        }
        return userRoles;
    }
}

