/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.MissingReference;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.portal.lar.CurrentUserIdStrategy;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ExportImportHelperImpl
implements ExportImportHelper {
    private static final char[] _DL_REFERENCE_LEGACY_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '\"', ' '};
    private static final char[] _DL_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '?', '\"', ' '};
    private static final char[] _LAYOUT_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '?', '\"', ' '};
    private static Log _log = LogFactoryUtil.getLog(ExportImportHelperImpl.class);
    private Pattern _exportLinksToLayoutPattern = Pattern.compile("\\[([0-9]+)@(public|private\\-[a-z]*)\\]");
    private Pattern _importLinksToLayoutPattern = Pattern.compile("\\[([0-9]+)@(public|private\\-[a-z]*)@(\\p{XDigit}{8}\\-(?:\\p{XDigit}{4}\\-){3}\\p{XDigit}{12})@([^\\]]*)\\]");

    public Calendar getDate(PortletRequest portletRequest, String paramPrefix, boolean timeZoneSensitive) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int dateMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Month"));
        int dateDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Day"));
        int dateYear = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Year"));
        int dateHour = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Hour"));
        int dateMinute = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Minute"));
        int dateAmPm = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "AmPm"));
        if (dateAmPm == 1) {
            dateHour += 12;
        }
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            locale = themeDisplay.getLocale();
            timeZone = themeDisplay.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getTimeZone((String)"UTC");
        }
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        calendar.set(2, dateMonth);
        calendar.set(5, dateDay);
        calendar.set(1, dateYear);
        calendar.set(11, dateHour);
        calendar.set(12, dateMinute);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public DateRange getDateRange(PortletRequest portletRequest, long groupId, boolean privateLayout, long plid, String portletId) throws Exception {
        Date startDate = null;
        Date endDate = null;
        String range = ParamUtil.getString((PortletRequest)portletRequest, (String)"range");
        if (range.equals("dateRange")) {
            startDate = this.getDate(portletRequest, "startDate", true).getTime();
            endDate = this.getDate(portletRequest, "endDate", true).getTime();
        } else if (range.equals("fromLastPublishDate")) {
            if (Validator.isNotNull((String)portletId) && plid > 0L) {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
                long lastPublishDate = GetterUtil.getLong((String)preferences.getValue("last-publish-date", ""));
                if (lastPublishDate > 0L) {
                    endDate = new Date();
                    startDate = new Date(lastPublishDate);
                }
            } else {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
                long lastPublishDate = GetterUtil.getLong((String)layoutSet.getSettingsProperty("last-publish-date"));
                if (lastPublishDate > 0L) {
                    endDate = new Date();
                    startDate = new Date(lastPublishDate);
                }
            }
        } else if (range.equals("last")) {
            int rangeLast = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"last");
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        return new DateRange(startDate, endDate);
    }

    public Layout getExportableLayout(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        long defaultPlid;
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.isLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)scopeGroup.getClassPK());
        } else if (!scopeGroup.isCompany() && (defaultPlid = LayoutLocalServiceUtil.getDefaultPlid((long)themeDisplay.getSiteGroupId())) > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)defaultPlid);
        }
        return layout;
    }

    public ManifestSummary getManifestSummary(long userId, long groupId, Map<String, String[]> parameterMap, File file) throws Exception {
        final Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)group.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)this.getUserIdStrategy(userId, userIdStrategy), (ZipReader)zipReader);
        final ManifestSummary manifestSummary = new ManifestSummary();
        SAXParser saxParser = new SAXParser();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                String elementName = element.getName();
                if (elementName.equals("header")) {
                    String exportDateString = element.attributeValue("export-date");
                    Date exportDate = GetterUtil.getDate((String)exportDateString, (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z"));
                    manifestSummary.setExportDate(exportDate);
                } else if (elementName.equals("portlet")) {
                    String portletId = element.attributeValue("portlet-id");
                    try {
                        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)group.getCompanyId(), (String)portletId);
                        if (portlet.getPortletDataHandlerInstance() != null && GetterUtil.getBoolean((String)element.attributeValue("portlet-data"))) {
                            manifestSummary.addDataPortlet(portlet);
                        }
                        if (GetterUtil.getBoolean((String)element.attributeValue("portlet-setup"))) {
                            manifestSummary.addSetupPortlet(portlet);
                        }
                    }
                    catch (SystemException systemException) {}
                } else if (elementName.equals("staged-model")) {
                    String manifestSummaryKey = element.attributeValue("manifest-summary-key");
                    long modelAdditionCount = GetterUtil.getLong((String)element.attributeValue("addition-count"));
                    manifestSummary.addModelAdditionCount(manifestSummaryKey, modelAdditionCount);
                    long modelDeletionCount = GetterUtil.getLong((String)element.attributeValue("deletion-count"));
                    manifestSummary.addModelDeletionCount(manifestSummaryKey, modelDeletionCount);
                }
            }
        }, new String[]{"header", "portlet", "staged-model"});
        saxParser.setContentHandler((ContentHandler)elementHandler);
        InputStream is = portletDataContext.getZipEntryAsInputStream("/manifest.xml");
        if (is == null) {
            throw new LARFileException("manifest.xml is not in the LAR");
        }
        String manifestXMLContent = StringUtil.read((InputStream)is);
        saxParser.parse(new InputSource(new StringReader(manifestXMLContent)));
        return manifestSummary;
    }

    public ManifestSummary getManifestSummary(long userId, long groupId, Map<String, String[]> parameterMap, FileEntry fileEntry) throws Exception {
        File file = DLFileEntryLocalServiceUtil.getFile((long)userId, (long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
        File newFile = null;
        boolean rename = false;
        ManifestSummary manifestSummary = null;
        try {
            String newFileName = StringUtil.replace((String)file.getPath(), (String)file.getName(), (String)fileEntry.getTitle());
            newFile = new File(newFileName);
            rename = file.renameTo(newFile);
            if (!rename) {
                newFile = FileUtil.createTempFile((String)fileEntry.getExtension());
                FileUtil.copyFile((File)file, (File)newFile);
            }
            manifestSummary = this.getManifestSummary(userId, groupId, parameterMap, newFile);
        }
        catch (Throwable throwable) {
            if (rename) {
                newFile.renameTo(file);
            } else {
                FileUtil.delete(newFile);
            }
            throw throwable;
        }
        if (rename) {
            newFile.renameTo(file);
        } else {
            FileUtil.delete((File)newFile);
        }
        return manifestSummary;
    }

    public FileEntry getTempFileEntry(long groupId, long userId) throws PortalException, SystemException {
        String[] tempFileEntryNames = LayoutServiceUtil.getTempFileEntryNames((long)groupId, (String)TEMP_FOLDER_NAME);
        if (tempFileEntryNames.length == 0) {
            return null;
        }
        return TempFileUtil.getTempFile((long)groupId, (long)userId, (String)tempFileEntryNames[0], (String)TEMP_FOLDER_NAME);
    }

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel entityStagedModel, Element entityElement, String content, boolean exportReferencedContent) throws Exception {
        content = ExportImportHelperUtil.replaceExportLayoutReferences((PortletDataContext)portletDataContext, (String)content, (boolean)exportReferencedContent);
        content = ExportImportHelperUtil.replaceExportLinksToLayouts((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, (Element)entityElement, (String)content, (boolean)exportReferencedContent);
        content = ExportImportHelperUtil.replaceExportDLReferences((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, (Element)entityElement, (String)content, (boolean)exportReferencedContent);
        Element groupElement = entityElement.getParent();
        String groupElementName = groupElement.getName();
        if (!groupElementName.equals(JournalArticle.class.getSimpleName())) {
            content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        }
        return content;
    }

    public String replaceExportDLReferences(PortletDataContext portletDataContext, StagedModel entityStagedModel, Element entityElement, String content, boolean exportReferencedContent) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("20")) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String contextPath = PortalUtil.getPathContext();
        String[] patterns = new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block8: {
                Map<String, String[]> dlReferenceParameters = this.getDLReferenceParameters(portletDataContext, content, beginPos + contextPath.length(), endPos);
                FileEntry fileEntry = this.getFileEntry(portletDataContext, dlReferenceParameters);
                if (fileEntry == null) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger(dlReferenceParameters, (String)"endPos");
                try {
                    if (exportReferencedContent) {
                        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
                    }
                    portletDataContext.addReferenceElement(entityStagedModel, entityElement, (ClassedModel)fileEntry, FileEntry.class, "dependency", !exportReferencedContent);
                    String path = ExportImportPathUtil.getModelPath((long)fileEntry.getGroupId(), (String)FileEntry.class.getName(), (long)fileEntry.getFileEntryId());
                    sb.replace(beginPos, endPos, "[$dl-reference=" + path + "$]");
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e2, (Throwable)e2);
                    }
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)e2.getMessage());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    public String replaceExportLayoutReferences(PortletDataContext portletDataContext, String content, boolean exportReferencedContent) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        StringBuilder sb = new StringBuilder(content);
        String[] patterns = new String[]{"href=", "[["};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            int endGroupPos;
            String groupFriendlyURL;
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c2 = content.charAt(beginPos + offset);
                if (c2 == '\'' || c2 == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[') {
                offset = 2;
            }
            if ((endPos = StringUtil.indexOfAny((String)content, (char[])_LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos)) == -1) {
                endPos = beginPos - 1;
                continue;
            }
            String url = content.substring(beginPos + offset, endPos);
            String servletMapping = null;
            String servletMappingParam = null;
            if (url.startsWith(PortalUtil.getPathFriendlyURLPrivateGroup())) {
                servletMapping = PortalUtil.getPathFriendlyURLPrivateGroup();
                servletMappingParam = "@data_handler_private_group_servlet_mapping@";
            } else if (url.startsWith(PortalUtil.getPathFriendlyURLPrivateUser())) {
                servletMapping = PortalUtil.getPathFriendlyURLPrivateUser();
                servletMappingParam = "@data_handler_private_user_servlet_mapping@";
            } else if (url.startsWith(PortalUtil.getPathFriendlyURLPublic())) {
                servletMapping = PortalUtil.getPathFriendlyURLPublic();
                servletMappingParam = "@data_handler_public_servlet_mapping@";
            } else {
                endPos = beginPos - 1;
                continue;
            }
            int beginGroupPos = beginPos + offset + servletMapping.length();
            if (content.charAt(beginGroupPos) == '/' && (groupFriendlyURL = content.substring(beginGroupPos, endGroupPos = (endGroupPos = url.indexOf(47, servletMapping.length() + 1)) == -1 ? endPos : endGroupPos + beginPos + offset)).equals(group.getFriendlyURL())) {
                sb.replace(beginGroupPos, endGroupPos, "@data_handler_group_friendly_url@");
            }
            sb.replace(beginPos + offset, beginGroupPos, servletMappingParam);
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    public String replaceExportLinksToLayouts(PortletDataContext portletDataContext, StagedModel entityStagedModel, Element entityElement, String content, boolean exportReferencedContent) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = this._exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId = GetterUtil.getLong((String)matcher.group(1));
            String type = matcher.group(2);
            boolean privateLayout = type.startsWith("private");
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (long)layoutId);
                String oldLinkToLayout = matcher.group(0);
                StringBundler sb = new StringBundler(5);
                sb.append(type);
                sb.append("@");
                sb.append(layout.getUuid());
                sb.append("@");
                sb.append(layout.getFriendlyURL());
                String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String)type, (String)sb.toString());
                oldLinksToLayout.add(oldLinkToLayout);
                newLinksToLayout.add(newLinkToLayout);
                if (exportReferencedContent) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout);
                }
                portletDataContext.addReferenceElement(entityStagedModel, entityElement, (ClassedModel)layout, Layout.class, "dependency", !exportReferencedContent);
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled() && !_log.isWarnEnabled()) continue;
                String message = "Unable to get layout with ID " + layoutId + " in group " + portletDataContext.getScopeGroupId();
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)message);
                    continue;
                }
                _log.debug((Object)message, (Throwable)e2);
            }
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, Element entityElement, String content, boolean importReferencedContent) throws Exception {
        content = ExportImportHelperUtil.replaceImportLayoutReferences((PortletDataContext)portletDataContext, (String)content, (boolean)importReferencedContent);
        content = ExportImportHelperUtil.replaceImportLinksToLayouts((PortletDataContext)portletDataContext, (String)content, (boolean)importReferencedContent);
        content = ExportImportHelperUtil.replaceImportDLReferences((PortletDataContext)portletDataContext, (Element)entityElement, (String)content, (boolean)importReferencedContent);
        return content;
    }

    public String replaceImportDLReferences(PortletDataContext portletDataContext, Element entityElement, String content, boolean importReferencedContent) throws Exception {
        List referenceDataElements = portletDataContext.getReferenceDataElements(entityElement, FileEntry.class);
        for (Element referenceDataElement : referenceDataElements) {
            String fileEntryUUID = referenceDataElement.attributeValue("uuid");
            if (fileEntryUUID == null) continue;
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)referenceDataElement);
            String path = referenceDataElement.attributeValue("path");
            FileEntry fileEntry = null;
            try {
                long groupId = portletDataContext.getScopeGroupId();
                long fileEntryGroupId = GetterUtil.getLong((String)referenceDataElement.attributeValue("group-id"));
                if (fileEntryGroupId == portletDataContext.getSourceCompanyGroupId()) {
                    groupId = portletDataContext.getSourceCompanyGroupId();
                }
                fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)fileEntryUUID, (long)groupId);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to reference " + path));
                continue;
            }
            String url = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            content = StringUtil.replace((String)content, (String)("[$dl-reference=" + path + "$]"), (String)url);
        }
        return content;
    }

    public String replaceImportLayoutReferences(PortletDataContext portletDataContext, String content, boolean importReferencedContent) throws Exception {
        content = StringUtil.replace((String)content, (String)"@data_handler_private_group_servlet_mapping@", (String)PortalUtil.getPathFriendlyURLPrivateGroup());
        content = StringUtil.replace((String)content, (String)"@data_handler_private_user_servlet_mapping@", (String)PortalUtil.getPathFriendlyURLPrivateUser());
        content = StringUtil.replace((String)content, (String)"@data_handler_public_servlet_mapping@", (String)PortalUtil.getPathFriendlyURLPublic());
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        content = StringUtil.replace((String)content, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        return content;
    }

    public String replaceImportLinksToLayouts(PortletDataContext portletDataContext, String content, boolean importReferencedContent) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = this._importLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            StringBundler sb;
            String friendlyURL;
            String layoutUuid;
            long newLayoutId;
            long oldLayoutId;
            block9: {
                newLayoutId = oldLayoutId = GetterUtil.getLong((String)matcher.group(1));
                String type = matcher.group(2);
                boolean privateLayout = type.startsWith("private");
                layoutUuid = matcher.group(3);
                friendlyURL = matcher.group(4);
                try {
                    Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)portletDataContext.getScopeGroupId(), (boolean)privateLayout);
                    if (layout == null) {
                        layout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (String)friendlyURL);
                    }
                    if (layout == null) {
                        layout = LayoutLocalServiceUtil.fetchLayout((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (long)oldLayoutId);
                    }
                    if (layout == null) {
                        if (_log.isWarnEnabled()) {
                            sb = new StringBundler(9);
                            sb.append("Unable to get layout with UUID ");
                            sb.append(layoutUuid);
                            sb.append(", friendly URL ");
                            sb.append(friendlyURL);
                            sb.append(", or ");
                            sb.append("layoutId ");
                            sb.append(oldLayoutId);
                            sb.append(" in group ");
                            sb.append(portletDataContext.getScopeGroupId());
                            _log.warn((Object)sb.toString());
                        }
                    } else {
                        newLayoutId = layout.getLayoutId();
                    }
                }
                catch (SystemException se) {
                    if (!_log.isDebugEnabled() && !_log.isWarnEnabled()) break block9;
                    String message = "Unable to get layout in group " + portletDataContext.getScopeGroupId();
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)message);
                    }
                    _log.debug((Object)message, (Throwable)se);
                }
            }
            String oldLinkToLayout = matcher.group(0);
            sb = new StringBundler(4);
            sb.append("@");
            sb.append(layoutUuid);
            sb.append("@");
            sb.append(friendlyURL);
            String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String[])new String[]{sb.toString(), String.valueOf(oldLayoutId)}, (String[])new String[]{"", String.valueOf(newLayoutId)});
            oldLinksToLayout.add(oldLinkToLayout);
            newLinksToLayout.add(newLinkToLayout);
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    public Map<String, MissingReference> validateMissingReferences(long userId, long groupId, Map<String, String[]> parameterMap, File file) throws Exception {
        final HashMap<String, MissingReference> missingReferences = new HashMap<String, MissingReference>();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        final PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)group.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)this.getUserIdStrategy(userId, userIdStrategy), (ZipReader)zipReader);
        SAXParser saxParser = new SAXParser();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                MissingReference missingReference = ExportImportHelperImpl.this.validateMissingReference(portletDataContext, element);
                if (missingReference != null) {
                    MissingReference existingMissingReference = (MissingReference)missingReferences.get(missingReference.getDisplayName());
                    if (existingMissingReference != null) {
                        existingMissingReference.addReferrers(missingReference.getReferrers());
                    } else {
                        missingReferences.put(missingReference.getDisplayName(), missingReference);
                    }
                }
            }
        }, new String[]{"missing-reference"});
        saxParser.setContentHandler((ContentHandler)elementHandler);
        saxParser.parse(new InputSource(portletDataContext.getZipEntryAsInputStream("/manifest.xml")));
        return missingReferences;
    }

    public void writeManifestSummary(Document document, ManifestSummary manifestSummary) {
        Element rootElement = document.getRootElement();
        Element manifestSummaryElement = rootElement.addElement("manifest-summary");
        for (String manifestSummaryKey : manifestSummary.getManifestSummaryKeys()) {
            long modelDeletionCount;
            Element element = manifestSummaryElement.addElement("staged-model");
            element.addAttribute("manifest-summary-key", manifestSummaryKey);
            long modelAdditionCount = manifestSummary.getModelAdditionCount(manifestSummaryKey);
            if (modelAdditionCount > 0L) {
                element.addAttribute("addition-count", String.valueOf(modelAdditionCount));
            }
            if ((modelDeletionCount = manifestSummary.getModelDeletionCount(manifestSummaryKey)) <= 0L) continue;
            element.addAttribute("deletion-count", String.valueOf(modelDeletionCount));
        }
    }

    protected Map<String, String[]> getDLReferenceParameters(PortletDataContext portletDataContext, String content, int beginPos, int endPos) {
        boolean legacyURL = true;
        char[] stopChars = _DL_REFERENCE_LEGACY_STOP_CHARS;
        if (content.startsWith("/documents/", beginPos)) {
            legacyURL = false;
            stopChars = _DL_REFERENCE_STOP_CHARS;
        }
        if ((endPos = StringUtil.indexOfAny((String)content, (char[])stopChars, (int)beginPos, (int)endPos)) == -1) {
            return null;
        }
        Map<String, String[]> map = new HashMap<String, String[]>();
        String dlReference = content.substring(beginPos, endPos);
        while (dlReference.contains("&amp;")) {
            dlReference = dlReference.replace("&amp;", "&");
        }
        if (!legacyURL) {
            String[] pathArray = dlReference.split("/");
            map.put("groupId", new String[]{pathArray[2]});
            if (pathArray.length == 4) {
                map.put("uuid", new String[]{pathArray[3]});
            } else if (pathArray.length == 5) {
                map.put("folderId", new String[]{pathArray[3]});
                map.put("title", new String[]{HttpUtil.decodeURL((String)pathArray[4])});
            } else if (pathArray.length > 5) {
                map.put("uuid", new String[]{pathArray[5]});
            }
        } else {
            map = HttpUtil.parameterMapFromString((String)(dlReference = dlReference.substring(dlReference.indexOf(63) + 1)));
            if (map.containsKey("img_id")) {
                map.put("image_id", (String[])map.get("img_id"));
            } else if (map.containsKey("i_id")) {
                map.put("image_id", (String[])map.get("i_id"));
            }
        }
        map.put("endPos", new String[]{String.valueOf(endPos)});
        String groupIdString = MapUtil.getString(map, (String)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(portletDataContext.getScopeGroupId());
            map.put("groupId", new String[]{groupIdString});
        }
        return map;
    }

    protected FileEntry getFileEntry(PortletDataContext portletDataContext, Map<String, String[]> map) {
        FileEntry fileEntry;
        block12: {
            if (map == null) {
                return null;
            }
            fileEntry = null;
            try {
                DLFileEntry dlFileEntry;
                String uuid = MapUtil.getString(map, (String)"uuid");
                long groupId = MapUtil.getLong(map, (String)"groupId");
                if (Validator.isNotNull((String)uuid)) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                } else if (map.containsKey("folderId")) {
                    long folderId = MapUtil.getLong(map, (String)"folderId");
                    String name = MapUtil.getString(map, (String)"name");
                    String title = MapUtil.getString(map, (String)"title");
                    if (Validator.isNotNull((String)title)) {
                        fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
                    } else {
                        DLFileEntry dlFileEntry2 = DLFileEntryLocalServiceUtil.fetchFileEntryByName((long)groupId, (long)folderId, (String)name);
                        if (dlFileEntry2 != null) {
                            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry2.getFileEntryId());
                        }
                    }
                } else if (map.containsKey("image_id") && (dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByAnyImageId((long)MapUtil.getLong(map, (String)"image_id"))) != null) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                }
            }
            catch (Exception e2) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e2, (Throwable)e2);
                }
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)e2.getMessage());
            }
        }
        return fileEntry;
    }

    protected UserIdStrategy getUserIdStrategy(long userId, String userIdStrategy) throws Exception {
        User user = UserLocalServiceUtil.getUserById((long)userId);
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    protected MissingReference validateMissingReference(PortletDataContext portletDataContext, Element element) {
        String className = element.attributeValue("class-name");
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)className);
        if (!stagedModelDataHandler.validateReference(portletDataContext, element.getParent(), element)) {
            return new MissingReference(element);
        }
        return null;
    }
}

