/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.SystemEvent;
import com.liferay.portal.service.persistence.SystemEventActionableDynamicQuery;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.Set;

public class DeletionSystemEventExporter {
    public void export(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("deletion-system-events");
        Set deletionEventClassNameIds = portletDataContext.getDeletionSystemEventClassNameIds();
        if (!deletionEventClassNameIds.isEmpty()) {
            this.doExport(portletDataContext, rootElement, deletionEventClassNameIds);
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/deletion-system-events.xml", document.formattedString());
    }

    protected void doExport(final PortletDataContext portletDataContext, final Element rootElement, final Set<Long> deletionEventClassNameIds) throws PortalException, SystemException {
        SystemEventActionableDynamicQuery actionableDynamicQuery = new SystemEventActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                if (!deletionEventClassNameIds.isEmpty()) {
                    Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                    dynamicQuery.add(classNameIdProperty.in(deletionEventClassNameIds.toArray()));
                }
                Property typeProperty = PropertyFactoryUtil.forName((String)"type");
                dynamicQuery.add(typeProperty.eq((Object)1));
                this._addCreateDateProperty(dynamicQuery);
            }

            protected void performAction(Object object) {
                SystemEvent systemEvent = (SystemEvent)object;
                DeletionSystemEventExporter.this.exportDeletionSystemEvent(portletDataContext, systemEvent, rootElement);
            }

            private void _addCreateDateProperty(DynamicQuery dynamicQuery) {
                if (!portletDataContext.hasDateRange()) {
                    return;
                }
                Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
                Date startDate = portletDataContext.getStartDate();
                dynamicQuery.add(createDateProperty.ge((Object)startDate));
                Date endDate = portletDataContext.getEndDate();
                dynamicQuery.add(createDateProperty.le((Object)endDate));
            }
        };
        actionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        actionableDynamicQuery.performActions();
    }

    protected void exportDeletionSystemEvent(PortletDataContext portletDataContext, SystemEvent systemEvent, Element deletionSystemEventsElement) {
        Element deletionSystemEventElement = deletionSystemEventsElement.addElement("deletion-system-event");
        deletionSystemEventElement.addAttribute("class-name", PortalUtil.getClassName((long)systemEvent.getClassNameId()));
        deletionSystemEventElement.addAttribute("group-id", String.valueOf(systemEvent.getGroupId()));
        deletionSystemEventElement.addAttribute("uuid", systemEvent.getClassUuid());
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        manifestSummary.incrementModelDeletionCount(PortalUtil.getClassName((long)systemEvent.getClassNameId()));
    }
}

