/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

@DoPrivileged
public class LanguageImpl
implements Language {
    private static Log _log = LogFactoryUtil.getLog(LanguageImpl.class);
    private static Map<Long, LanguageImpl> _instances = new ConcurrentHashMap<Long, LanguageImpl>();
    private Map<String, String> _charEncodings;
    private Set<String> _duplicateLanguageCodes;
    private Locale[] _locales;
    private Set<Locale> _localesBetaSet;
    private Map<String, Locale> _localesMap;
    private Set<Locale> _localesSet;

    public String format(Locale locale, String pattern, List<Object> arguments) {
        return this.format(locale, pattern, arguments.toArray(), true);
    }

    public String format(Locale locale, String pattern, Object argument) {
        return this.format(locale, pattern, new Object[]{argument}, true);
    }

    public String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(Locale locale, String pattern, Object[] arguments) {
        return this.format(locale, pattern, arguments, true);
    }

    public String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(locale, pattern);
                if (arguments != null && arguments.length > 0) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        formattedArguments[i2] = translateArguments ? this.get(locale, arguments[i2].toString()) : arguments[i2];
                        ++i2;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper argument) {
        return this.format(pageContext, pattern, new LanguageWrapper[]{argument}, true);
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return this.format(pageContext, pattern, new LanguageWrapper[]{argument}, translateArguments);
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper[] arguments) {
        return this.format(pageContext, pattern, arguments, true);
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(pageContext, pattern);
                if (arguments != null && arguments.length > 0) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        formattedArguments[i2] = translateArguments ? String.valueOf(arguments[i2].getBefore()) + this.get(pageContext, arguments[i2].getText()) + arguments[i2].getAfter() : String.valueOf(arguments[i2].getBefore()) + arguments[i2].getText() + arguments[i2].getAfter();
                        ++i2;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String format(PageContext pageContext, String pattern, Object argument) {
        return this.format(pageContext, pattern, new Object[]{argument}, true);
    }

    public String format(PageContext pageContext, String pattern, Object argument, boolean translateArguments) {
        return this.format(pageContext, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(PageContext pageContext, String pattern, Object[] arguments) {
        return this.format(pageContext, pattern, arguments, true);
    }

    public String format(PageContext pageContext, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(pageContext, pattern);
                if (arguments != null && arguments.length > 0) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        formattedArguments[i2] = translateArguments ? this.get(pageContext, arguments[i2].toString()) : arguments[i2];
                        ++i2;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object argument) {
        return this.format(portletConfig, locale, pattern, new Object[]{argument}, true);
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(portletConfig, locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object[] arguments) {
        return this.format(portletConfig, locale, pattern, arguments, true);
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(portletConfig, locale, pattern);
                if (arguments != null && arguments.length > 0) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        formattedArguments[i2] = translateArguments ? this.get(locale, arguments[i2].toString()) : arguments[i2];
                        ++i2;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String get(Locale locale, String key) {
        return this.get(locale, key, key);
    }

    public String get(Locale locale, String key, String defaultValue) {
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (key == null) {
            return null;
        }
        String value = LanguageResources.getMessage(locale, key);
        while (value == null || value.equals(defaultValue)) {
            int pos;
            if (key.length() <= 0 || key.charAt(key.length() - 1) != ']' || (pos = key.lastIndexOf(91)) == -1) break;
            key = key.substring(0, pos);
            value = LanguageResources.getMessage(locale, key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String get(PageContext pageContext, String key) {
        return this.get(pageContext, key, key);
    }

    public String get(PageContext pageContext, String key, String defaultValue) {
        try {
            return this._get(pageContext, null, null, key, defaultValue);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return defaultValue;
        }
    }

    public String get(PortletConfig portletConfig, Locale locale, String key) {
        return this.get(portletConfig, locale, key, key);
    }

    public String get(PortletConfig portletConfig, Locale locale, String key, String defaultValue) {
        try {
            return this._get(null, portletConfig, locale, key, defaultValue);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return defaultValue;
        }
    }

    public Locale[] getAvailableLocales() {
        return LanguageImpl._getInstance()._locales;
    }

    public String getCharset(Locale locale) {
        return LanguageImpl._getInstance()._getCharset(locale);
    }

    public String getLanguageId(HttpServletRequest request) {
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        if (Validator.isNotNull((String)languageId) && (this._localesMap.containsKey(languageId) || this._charEncodings.containsKey(languageId))) {
            return languageId;
        }
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        return this.getLanguageId(locale);
    }

    public String getLanguageId(Locale locale) {
        return LocaleUtil.toLanguageId((Locale)locale);
    }

    public String getLanguageId(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getLanguageId(request);
    }

    public Locale getLocale(String languageCode) {
        return LanguageImpl._getInstance()._getLocale(languageCode);
    }

    public Locale[] getSupportedLocales() {
        Locale[] locales;
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        Locale[] localeArray = locales = this.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (!this.isBetaLocale(locale)) {
                supportedLocales.add(locale);
            }
            ++n2;
        }
        return supportedLocales.toArray(new Locale[supportedLocales.size()]);
    }

    public String getTimeDescription(Locale locale, long milliseconds) {
        return this.getTimeDescription(locale, milliseconds, false);
    }

    public String getTimeDescription(Locale locale, long milliseconds, boolean approximate) {
        String value;
        block2: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                int pos = description.indexOf(32);
                String x = description.substring(0, pos);
                value = x.concat(" ").concat(this.get(locale, description.substring(pos + 1, description.length()).toLowerCase()));
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String getTimeDescription(Locale locale, Long milliseconds) {
        return this.getTimeDescription(locale, (long)milliseconds);
    }

    public String getTimeDescription(PageContext pageContext, long milliseconds) {
        return this.getTimeDescription(pageContext, milliseconds, false);
    }

    public String getTimeDescription(PageContext pageContext, long milliseconds, boolean approximate) {
        String value;
        block2: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                int pos = description.indexOf(32);
                String x = description.substring(0, pos);
                value = x.concat(" ").concat(this.get(pageContext, description.substring(pos + 1, description.length()).toLowerCase()));
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String getTimeDescription(PageContext pageContext, Long milliseconds) {
        return this.getTimeDescription(pageContext, (long)milliseconds);
    }

    public void init() {
        _instances.clear();
    }

    public boolean isAvailableLanguageCode(String languageCode) {
        return LanguageImpl._getInstance()._localesMap.containsKey(languageCode);
    }

    public boolean isAvailableLocale(Locale locale) {
        return LanguageImpl._getInstance()._localesSet.contains(locale);
    }

    public boolean isBetaLocale(Locale locale) {
        return LanguageImpl._getInstance()._localesBetaSet.contains(locale);
    }

    public boolean isDuplicateLanguageCode(String languageCode) {
        return LanguageImpl._getInstance()._duplicateLanguageCodes.contains(languageCode);
    }

    public void resetAvailableLocales(long companyId) {
        this._resetAvailableLocales(companyId);
    }

    public void updateCookie(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        Cookie languageIdCookie = new Cookie("GUEST_LANGUAGE_ID", languageId);
        languageIdCookie.setPath("/");
        languageIdCookie.setMaxAge(1471228928);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)languageIdCookie);
    }

    private static LanguageImpl _getInstance() {
        Long companyId = CompanyThreadLocal.getCompanyId();
        LanguageImpl instance = _instances.get(companyId);
        if (instance == null) {
            instance = new LanguageImpl(companyId);
            _instances.put(companyId, instance);
        }
        return instance;
    }

    private LanguageImpl() {
        this(0L);
    }

    private LanguageImpl(long companyId) {
        String languageId;
        String[] localesArray = PropsValues.LOCALES;
        if (companyId != 0L) {
            try {
                localesArray = PrefsPropsUtil.getStringArray(companyId, "locales", ",", PropsValues.LOCALES_ENABLED);
            }
            catch (SystemException systemException) {
                localesArray = PropsValues.LOCALES_ENABLED;
            }
        }
        this._charEncodings = new HashMap<String, String>();
        this._duplicateLanguageCodes = new HashSet<String>();
        this._locales = new Locale[localesArray.length];
        this._localesMap = new HashMap<String, Locale>(localesArray.length);
        this._localesSet = new HashSet<Locale>(localesArray.length);
        int i2 = 0;
        while (i2 < localesArray.length) {
            languageId = localesArray[i2];
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            this._charEncodings.put(locale.toString(), "UTF-8");
            String language = languageId;
            int pos = languageId.indexOf(95);
            if (pos > 0) {
                language = languageId.substring(0, pos);
            }
            if (this._localesMap.containsKey(language)) {
                this._duplicateLanguageCodes.add(language);
            }
            this._locales[i2] = locale;
            if (!this._localesMap.containsKey(language)) {
                this._localesMap.put(language, locale);
            }
            this._localesSet.add(locale);
            ++i2;
        }
        String[] localesBetaArray = PropsValues.LOCALES_BETA;
        this._localesBetaSet = new HashSet<Locale>(localesBetaArray.length);
        String[] stringArray = localesBetaArray;
        int n = localesBetaArray.length;
        int n2 = 0;
        while (n2 < n) {
            languageId = stringArray[n2];
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            this._localesBetaSet.add(locale);
            ++n2;
        }
    }

    private String _escapePattern(String pattern) {
        return StringUtil.replace((String)pattern, (String)"'", (String)"''");
    }

    private String _get(PageContext pageContext, PortletConfig portletConfig, Locale locale, String key, String defaultValue) throws Exception {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (key == null) {
            return null;
        }
        String value = null;
        if (pageContext != null) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            locale = themeDisplay.getLocale();
            portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        }
        if (portletConfig != null) {
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
            value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
            String portletName = portletConfig.getPortletName();
            if ((value == null || value.equals(defaultValue)) && portletName.equals("86")) {
                value = this._getPortletConfigurationValue(pageContext, locale, key);
            }
            if (value != null) {
                value = LanguageResources.fixValue(value);
            }
        }
        if (value == null || value.equals(defaultValue)) {
            value = LanguageResources.getMessage(locale, key);
        }
        if ((value == null || value.equals(defaultValue)) && key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this._get(pageContext, portletConfig, locale, key, defaultValue);
        }
        if (value == null || value.equals(key)) {
            value = defaultValue;
        }
        return value;
    }

    private String _getCharset(Locale locale) {
        return "UTF-8";
    }

    private Locale _getLocale(String languageCode) {
        return this._localesMap.get(languageCode);
    }

    private String _getPortletConfigurationValue(PageContext pageContext, Locale locale, String key) throws Exception {
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletResource);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)pageContext.getServletContext());
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
    }

    private void _resetAvailableLocales(long companyId) {
        _instances.remove(companyId);
    }
}

