/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.spring;

import com.liferay.portal.kernel.annotation.AnnotationLocator;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMappingResolver;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class JSONWebServiceDetectorBeanPostProcessor
implements BeanPostProcessor {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceDetectorBeanPostProcessor.class);
    private static Set<String> _excludedMethodNames = SetUtil.fromArray((Object[])new String[]{"getBeanIdentifier", "setBeanIdentifier"});
    private Set<String> _invalidHttpMethods = SetUtil.fromArray((Object[])PropsUtil.getArray((String)"jsonws.web.service.invalid.http.methods"));
    private JSONWebServiceMappingResolver _jsonWebServiceMappingResolver = new JSONWebServiceMappingResolver();
    private Map<Class<?>, Class<?>> _utilClasses = new HashMap();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!PropsValues.JSON_WEB_SERVICE_ENABLED || !beanName.endsWith("Service")) {
            return bean;
        }
        JSONWebService jsonWebService = (JSONWebService)AnnotationLocator.locate(bean.getClass(), JSONWebService.class);
        if (jsonWebService != null) {
            try {
                this.onJSONWebServiceBean(bean, jsonWebService);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        return bean;
    }

    protected Class<?> loadUtilClass(Class<?> implementationClass) throws ClassNotFoundException {
        Class<?> utilClass = this._utilClasses.get(implementationClass);
        if (utilClass != null) {
            return utilClass;
        }
        String implementationClassName = implementationClass.getName();
        if (implementationClassName.endsWith("Impl")) {
            implementationClassName = implementationClassName.substring(0, implementationClassName.length() - 4);
        }
        String utilClassName = String.valueOf(implementationClassName) + "Util";
        utilClassName = StringUtil.replace((String)utilClassName, (String)".impl.", (String)".");
        ClassLoader classLoader = implementationClass.getClassLoader();
        utilClass = classLoader.loadClass(utilClassName);
        this._utilClasses.put(implementationClass, utilClass);
        return utilClass;
    }

    protected void onJSONWebServiceBean(Object serviceBean, JSONWebService jsonWebService) throws Exception {
        Method[] methods;
        JSONWebServiceMode jsonWebServiceMode = JSONWebServiceMode.MANUAL;
        if (jsonWebService != null) {
            jsonWebServiceMode = jsonWebService.mode();
        }
        Class<?> serviceBeanClass = serviceBean.getClass();
        Method[] methodArray = methods = serviceBeanClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> declaringClass = method.getDeclaringClass();
            if (!(declaringClass != serviceBeanClass || _excludedMethodNames != null && _excludedMethodNames.contains(method.getName()))) {
                JSONWebServiceMode methodJSONWebServiceMode;
                JSONWebService methodJSONWebService = method.getAnnotation(JSONWebService.class);
                if (jsonWebServiceMode.equals((Object)JSONWebServiceMode.AUTO)) {
                    if (methodJSONWebService == null) {
                        this.registerJSONWebServiceAction(serviceBean, method);
                    } else {
                        methodJSONWebServiceMode = methodJSONWebService.mode();
                        if (!methodJSONWebServiceMode.equals((Object)JSONWebServiceMode.IGNORE)) {
                            this.registerJSONWebServiceAction(serviceBean, method);
                        }
                    }
                } else if (methodJSONWebService != null && !(methodJSONWebServiceMode = methodJSONWebService.mode()).equals((Object)JSONWebServiceMode.IGNORE)) {
                    this.registerJSONWebServiceAction(serviceBean, method);
                }
            }
            ++n2;
        }
    }

    protected void registerJSONWebServiceAction(Object serviceBean, Method method) throws Exception {
        String httpMethod = this._jsonWebServiceMappingResolver.resolveHttpMethod(method);
        if (this._invalidHttpMethods.contains(httpMethod)) {
            return;
        }
        String servletContextName = PortletClassLoaderUtil.getServletContextName();
        if (servletContextName != null) {
            ServletContext servletContext = ServletContextPool.get((String)servletContextName);
            servletContextName = servletContext.getContextPath();
        } else {
            servletContextName = PortalContextLoaderListener.getPortalServletContextPath();
            if (servletContextName.equals("/")) {
                servletContextName = "";
            }
        }
        Class<?> serviceBeanClass = serviceBean.getClass();
        Class<?> utilClass = this.loadUtilClass(serviceBeanClass);
        try {
            method = utilClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        String path = this._jsonWebServiceMappingResolver.resolvePath(serviceBeanClass, method);
        JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)servletContextName, method.getDeclaringClass(), (Method)method, (String)path, (String)httpMethod);
    }
}

