/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jodd.util.Wildcard;

public class JSONWebServiceDiscoverAction
implements JSONWebServiceAction {
    private String _basePath;
    private String _baseURL;
    private String _contextPath;
    private String[] _discover;
    private List<Class<?>> _types = new ArrayList();

    public JSONWebServiceDiscoverAction(HttpServletRequest request) {
        this._basePath = request.getServletPath();
        this._baseURL = request.getRequestURL().toString();
        this._contextPath = request.getContextPath();
        String discover = request.getParameter("discover");
        this._discover = StringUtil.split((String)discover);
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return null;
    }

    public Object invoke() throws Exception {
        LinkedHashMap<String, Object> resultsMap = new LinkedHashMap<String, Object>();
        Map<String, Object> jsonWebServiceActionMappingMaps = this._buildJsonWebServiceActionMappingMaps();
        resultsMap.put("actions", jsonWebServiceActionMappingMaps);
        resultsMap.put("context", this._contextPath);
        resultsMap.put("basePath", this._basePath);
        resultsMap.put("baseURL", this._baseURL);
        if (this._discover.length > 0) {
            resultsMap.put("discover", Arrays.toString(this._discover));
        }
        return resultsMap;
    }

    private Map<String, Object> _buildJsonWebServiceActionMappingMaps() throws PortalException {
        List jsonWebServiceActionMappingMaps = JSONWebServiceActionsManagerUtil.getJSONWebServiceActionMappings((String)this._contextPath);
        LinkedHashMap<String, Object> jsonWebServiceActionMappingsMap = new LinkedHashMap<String, Object>(jsonWebServiceActionMappingMaps.size());
        for (JSONWebServiceActionMapping jsonWebServiceActionMapping : jsonWebServiceActionMappingMaps) {
            String path = jsonWebServiceActionMapping.getPath();
            if (!this._isAcceptPath(path)) continue;
            LinkedHashMap<String, Object> jsonWebServiceActionMappingMap = new LinkedHashMap<String, Object>();
            jsonWebServiceActionMappingMap.put("method", jsonWebServiceActionMapping.getMethod());
            MethodParameter[] methodParameters = jsonWebServiceActionMapping.getMethodParameters();
            LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>(methodParameters.length);
            MethodParameter[] methodParameterArray = methodParameters;
            int n = methodParameters.length;
            int n2 = 0;
            while (n2 < n) {
                MethodParameter methodParameter = methodParameterArray[n2];
                Class[] genericTypes = null;
                try {
                    genericTypes = methodParameter.getGenericTypes();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PortalException((Throwable)cnfe);
                }
                parameterMap.put(methodParameter.getName(), this._formatType(methodParameter.getType(), genericTypes));
                ++n2;
            }
            jsonWebServiceActionMappingMap.put("parameters", parameterMap);
            jsonWebServiceActionMappingMap.put("path", path);
            Method actionMethod = jsonWebServiceActionMapping.getActionMethod();
            jsonWebServiceActionMappingMap.put("response", this._formatType(actionMethod.getReturnType(), null));
            jsonWebServiceActionMappingsMap.put(path, jsonWebServiceActionMappingMap);
        }
        return jsonWebServiceActionMappingsMap;
    }

    private String _formatType(Class<?> type, Class<?>[] genericTypes) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return String.valueOf(this._formatType(componentType, genericTypes)) + "[]";
        }
        if (type.isPrimitive()) {
            return type.getSimpleName();
        }
        if (type.equals(Date.class)) {
            return "long";
        }
        if (type.equals(Locale.class) || type.equals(String.class)) {
            return "string";
        }
        if (type.equals(Object.class) || type.equals(Serializable.class)) {
            return "object";
        }
        String typeName = type.getName();
        if (type.equals(List.class)) {
            typeName = "list";
        } else if (type.equals(Map.class)) {
            typeName = "map";
        } else {
            this._types.add(type);
        }
        if (genericTypes == null) {
            return "object<" + typeName + ">";
        }
        StringBundler sb = new StringBundler(genericTypes.length * 2 + 1);
        sb.append("<");
        int i2 = 0;
        while (i2 < genericTypes.length) {
            Class<?> genericType = genericTypes[i2];
            if (i2 != 0) {
                sb.append(",");
            }
            sb.append(this._formatType(genericType, null));
            ++i2;
        }
        sb.append(">");
        return String.valueOf(typeName) + sb.toString();
    }

    private boolean _isAcceptPath(String path) {
        if (this._discover.length == 0) {
            return true;
        }
        return Wildcard.matchOne((String)path, (String[])this._discover) != -1;
    }
}

