/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionImpl;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BinarySearch;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@DoPrivileged
public class JSONWebServiceActionsManagerImpl
implements JSONWebServiceActionsManager {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceActionsManagerImpl.class);
    private SortedArrayList<JSONWebServiceActionConfig> _jsonWebServiceActionConfigs = new SortedArrayList();
    private BinarySearch<String> _pathBinarySearch = new PathBinarySearch();

    public Set<String> getContextPaths() {
        TreeSet<String> contextPaths = new TreeSet<String>();
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            String contextPath = jsonWebServiceActionConfig.getContextPath();
            contextPaths.add(contextPath);
        }
        return contextPaths;
    }

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request) {
        int jsonWebServiceActionConfigIndex;
        String path = GetterUtil.getString((String)request.getPathInfo());
        String method = GetterUtil.getString((String)request.getMethod());
        String parameterPath = null;
        JSONRPCRequest jsonRPCRequest = null;
        int parameterPathIndex = this._getParameterPathIndex(path);
        if (parameterPathIndex != -1) {
            parameterPath = path.substring(parameterPathIndex);
            path = path.substring(0, parameterPathIndex);
        } else if (method.equals("POST") && !PortalUtil.isMultipartRequest((HttpServletRequest)request) && (jsonRPCRequest = JSONRPCRequest.detectJSONRPCRequest(request)) != null) {
            path = String.valueOf(path) + "/" + jsonRPCRequest.getMethod();
            method = null;
        }
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, parameterPath, jsonRPCRequest, null);
        String[] paths = this._resolvePaths(request, path);
        String contextPath = paths[0];
        path = paths[1];
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Request JSON web service action with path " + path + " and method " + method + " for /" + contextPath));
        }
        if ((jsonWebServiceActionConfigIndex = this._getJSONWebServiceActionConfigIndex(contextPath, path, method, jsonWebServiceActionParameters.getParameterNames())) == -1) {
            throw new RuntimeException("No JSON web service action associated with path " + path + " and method " + method + " for /" + contextPath);
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(jsonWebServiceActionConfigIndex);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters);
    }

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request, String path, String method, Map<String, Object> parameterMap) {
        int jsonWebServiceActionConfigIndex;
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, null, null, parameterMap);
        String[] parameterNames = jsonWebServiceActionParameters.getParameterNames();
        String[] paths = this._resolvePaths(request, path);
        String contextPath = paths[0];
        path = paths[1];
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Request JSON web service action with path " + path + " and method " + method + " for /" + contextPath));
        }
        if ((jsonWebServiceActionConfigIndex = this._getJSONWebServiceActionConfigIndex(contextPath, path, method, parameterNames)) == -1) {
            throw new RuntimeException("No JSON web service action with path " + path + " and method " + method + " for /" + contextPath);
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(jsonWebServiceActionConfigIndex);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters);
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping(String signature) {
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            if (!signature.equals(jsonWebServiceActionConfig.getSignature())) continue;
            return jsonWebServiceActionConfig;
        }
        return null;
    }

    public List<JSONWebServiceActionMapping> getJSONWebServiceActionMappings(String contextPath) {
        ArrayList<JSONWebServiceActionMapping> jsonWebServiceActionMappings = new ArrayList<JSONWebServiceActionMapping>(this._jsonWebServiceActionConfigs.size());
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            String jsonWebServiceContextPath = jsonWebServiceActionConfig.getContextPath();
            if (!contextPath.equals(jsonWebServiceContextPath)) continue;
            jsonWebServiceActionMappings.add(jsonWebServiceActionConfig);
        }
        return jsonWebServiceActionMappings;
    }

    public int getJSONWebServiceActionsCount(String contextPath) {
        int count = 0;
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            if (!contextPath.equals(jsonWebServiceActionConfig.getContextPath())) continue;
            ++count;
        }
        return count;
    }

    public void registerJSONWebServiceAction(String contextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        JSONWebServiceActionConfig jsonWebServiceActionConfig = new JSONWebServiceActionConfig(contextPath, actionClass, actionMethod, path, method);
        if (this._jsonWebServiceActionConfigs.contains((Object)jsonWebServiceActionConfig)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("A JSON web service action is already registered at " + path));
            }
            return;
        }
        this._jsonWebServiceActionConfigs.add((Object)jsonWebServiceActionConfig);
    }

    public int unregisterJSONWebServiceActions(String contextPath) {
        int count = 0;
        Iterator iterator = this._jsonWebServiceActionConfigs.iterator();
        while (iterator.hasNext()) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)iterator.next();
            if (!contextPath.equals(jsonWebServiceActionConfig.getContextPath())) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }

    private int _countMatchedElements(String[] parameterNames, MethodParameter[] methodParameters) {
        int matched = 0;
        MethodParameter[] methodParameterArray = methodParameters;
        int n = methodParameters.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter methodParameter = methodParameterArray[n2];
            String methodParameterName = methodParameter.getName();
            if (ArrayUtil.contains((Object[])parameterNames, (Object)(methodParameterName = CamelCaseUtil.normalizeCamelCase((String)methodParameterName)))) {
                ++matched;
            }
            ++n2;
        }
        return matched;
    }

    private int _getJSONWebServiceActionConfigIndex(String contextPath, String path, String method, String[] parameterNames) {
        int firstIndex;
        int hint = -1;
        int dotIndex = path.indexOf(46);
        if (dotIndex != -1) {
            hint = GetterUtil.getInteger((String)path.substring(dotIndex + 1));
            path = path.substring(0, dotIndex);
        }
        if ((firstIndex = this._pathBinarySearch.findFirst((Object)(path = String.valueOf(contextPath) + path))) < 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find JSON web service actions with path " + path + " for /" + contextPath));
            }
            return -1;
        }
        int lastIndex = this._pathBinarySearch.findLast((Object)path, firstIndex);
        if (lastIndex < 0) {
            lastIndex = firstIndex;
        }
        int index = -1;
        int max = -1;
        if (_log.isDebugEnabled()) {
            int total = lastIndex - firstIndex + 1;
            _log.debug((Object)("Found " + total + " JSON web service actions with path " + path + " in for /" + contextPath));
        }
        int i2 = firstIndex;
        while (i2 <= lastIndex) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(i2);
            String jsonWebServiceActionConfigMethod = jsonWebServiceActionConfig.getMethod();
            if (!PropsValues.JSONWS_WEB_SERVICE_STRICT_HTTP_METHOD || method == null || jsonWebServiceActionConfigMethod == null || jsonWebServiceActionConfigMethod.equals(method)) {
                int count;
                MethodParameter[] jsonWebServiceActionConfigMethodParameters = jsonWebServiceActionConfig.getMethodParameters();
                int methodParametersCount = jsonWebServiceActionConfigMethodParameters.length;
                if (!(hint != -1 && methodParametersCount != hint || (count = this._countMatchedElements(parameterNames, jsonWebServiceActionConfigMethodParameters)) <= max || hint == -1 && count < methodParametersCount)) {
                    max = count;
                    index = i2;
                }
            }
            ++i2;
        }
        if (_log.isDebugEnabled()) {
            if (index == -1) {
                _log.debug((Object)("Unable to match parameters to a JSON web service action with path " + path + " for /" + contextPath));
            } else {
                _log.debug((Object)("Matched parameters to a JSON web service action with path " + path + " for /" + contextPath));
            }
        }
        return index;
    }

    private int _getParameterPathIndex(String path) {
        int index = path.indexOf(47, 1);
        if (index != -1) {
            index = path.indexOf(47, index + 1);
        }
        return index;
    }

    private String[] _resolvePaths(HttpServletRequest request, String path) {
        String contextPath = null;
        int index = path.indexOf(47, 1);
        if (index != -1 && (index = path.lastIndexOf(46, index)) != -1) {
            contextPath = path.substring(0, index);
            path = String.valueOf('/') + path.substring(index + 1);
        }
        if (contextPath == null) {
            HttpSession session = request.getSession();
            ServletContext servletContext = session.getServletContext();
            contextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        }
        return new String[]{contextPath, path};
    }

    private class PathBinarySearch
    extends BinarySearch<String> {
        private PathBinarySearch() {
        }

        protected int compare(int index, String element) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)JSONWebServiceActionsManagerImpl.this._jsonWebServiceActionConfigs.get(index);
            String fullPath = jsonWebServiceActionConfig.getFullPath();
            return fullPath.compareTo(element);
        }

        protected int getLastIndex() {
            return JSONWebServiceActionsManagerImpl.this._jsonWebServiceActionConfigs.size() - 1;
        }
    }
}

