/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.servlet.ServletUtil;

public class JSONRPCRequest {
    private static Log _log = LogFactoryUtil.getLog(JSONRPCRequest.class);
    private Integer _id;
    private String _jsonrpc;
    private String _method;
    private Map<String, ?> _parameters;

    public static JSONRPCRequest detectJSONRPCRequest(HttpServletRequest request) {
        JSONRPCRequest jsonrpcRequest;
        block6: {
            String requestBody;
            block5: {
                try {
                    requestBody = ServletUtil.readRequestBody((HttpServletRequest)request);
                    if (!Validator.isNull((String)requestBody) && requestBody.startsWith("{") && requestBody.endsWith("}")) break block5;
                    return null;
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Unable to parse JSON RPC request", (Throwable)e2);
                    }
                    return null;
                }
            }
            JSONDeserializer jsonDeserializer = JSONFactoryUtil.createJSONDeserializer();
            jsonDeserializer.use(null, HashMap.class);
            jsonDeserializer.use("parameters", HashMap.class);
            HashMap requestBodyMap = (HashMap)jsonDeserializer.deserialize(requestBody);
            jsonrpcRequest = new JSONRPCRequest();
            jsonrpcRequest._id = (Integer)requestBodyMap.get("id");
            jsonrpcRequest._jsonrpc = (String)requestBodyMap.get("jsonrpc");
            jsonrpcRequest._method = (String)requestBodyMap.get("method");
            jsonrpcRequest._parameters = (Map)requestBodyMap.get("params");
            if (!Validator.isNull((String)jsonrpcRequest._method)) break block6;
            return null;
        }
        return jsonrpcRequest;
    }

    public Integer getId() {
        return this._id;
    }

    public String getJsonrpc() {
        return this._jsonrpc;
    }

    public String getMethod() {
        return this._method;
    }

    public String getParameter(String name) {
        Object value = this._parameters.get(name);
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public Set<String> getParameterNames() {
        return this._parameters.keySet();
    }

    public void setId(Integer id) {
        this._id = id;
    }

    public void setJsonrpc(String jsonrpc) {
        this._jsonrpc = jsonrpc;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setParameters(Map<String, ?> parameters) {
        this._parameters = parameters;
    }
}

