/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.image.LiferayConvertCmd;
import com.liferay.portal.image.LiferayIdentifyCmd;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.image.ImageMagick;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.portlet.PortletPreferences;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.im4java.process.ProcessExecutor;
import org.im4java.process.ProcessTask;

@DoPrivileged
public class ImageMagickImpl
implements ImageMagick {
    private static Log _log = LogFactoryUtil.getLog(ImageMagickImpl.class);
    private static ImageMagickImpl _instance = new ImageMagickImpl();
    private String _globalSearchPath;
    private volatile ProcessExecutor _processExecutor;
    private Properties _resourceLimitsProperties;
    private boolean _warned;

    public static ImageMagickImpl getInstance() {
        return _instance;
    }

    public Future<?> convert(List<String> arguments) throws Exception {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Cannot call \"convert\" when ImageMagick is disabled");
        }
        ProcessExecutor processExecutor = this._getProcessExecutor();
        LiferayConvertCmd liferayConvertCmd = new LiferayConvertCmd();
        ProcessTask processTask = liferayConvertCmd.getProcessTask(this._globalSearchPath, this.getResourceLimits(), arguments);
        processExecutor.execute((Runnable)processTask);
        return processTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this._processExecutor == null) {
            return;
        }
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            this._processExecutor.shutdownNow();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this._processExecutor = null;
            return;
        }
    }

    public String getGlobalSearchPath() throws Exception {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        String globalSearchPath = preferences.getValue("imagemagick.global.search.path", null);
        if (Validator.isNotNull((String)globalSearchPath)) {
            return globalSearchPath;
        }
        String filterName = null;
        filterName = OSDetector.isApple() ? "apple" : (OSDetector.isWindows() ? "windows" : "unix");
        return PropsUtil.get("imagemagick.global.search.path", new Filter(filterName));
    }

    public Properties getResourceLimitsProperties() throws Exception {
        Properties resourceLimitsProperties = PrefsPropsUtil.getProperties("imagemagick.resource.limit.", true);
        if (resourceLimitsProperties.isEmpty()) {
            resourceLimitsProperties = PropsUtil.getProperties("imagemagick.resource.limit.", true);
        }
        return resourceLimitsProperties;
    }

    public String[] identify(List<String> arguments) throws Exception {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Cannot call \"identify\" when ImageMagick is disabled");
        }
        ProcessExecutor processExecutor = this._getProcessExecutor();
        LiferayIdentifyCmd liferayIdentifyCmd = new LiferayIdentifyCmd();
        ArrayListOutputConsumer arrayListOutputConsumer = new ArrayListOutputConsumer();
        liferayIdentifyCmd.setOutputConsumer((OutputConsumer)arrayListOutputConsumer);
        ProcessTask processTask = liferayIdentifyCmd.getProcessTask(this._globalSearchPath, this.getResourceLimits(), arguments);
        processExecutor.execute((Runnable)processTask);
        processTask.get();
        ArrayList output = arrayListOutputConsumer.getOutput();
        if (output != null) {
            return output.toArray(new String[output.size()]);
        }
        return new String[0];
    }

    public boolean isEnabled() {
        boolean enabled = false;
        try {
            enabled = PrefsPropsUtil.getBoolean("imagemagick.enabled");
        }
        catch (Exception e2) {
            _log.warn((Object)e2, (Throwable)e2);
        }
        if (!enabled && !this._warned) {
            StringBundler sb = new StringBundler(7);
            sb.append("Liferay is not configured to use ImageMagick and ");
            sb.append("Ghostscript. For better quality document and image ");
            sb.append("previews, install ImageMagick and Ghostscript. Enable ");
            sb.append("ImageMagick in portal-ext.properties or in the Server ");
            sb.append("Administration section of the Control Panel at: ");
            sb.append("http://<server>/group/control_panel/manage/-/server/");
            sb.append("external-services");
            _log.warn((Object)sb.toString());
            this._warned = true;
        }
        return enabled;
    }

    public void reset() {
        if (this.isEnabled()) {
            try {
                this._globalSearchPath = this.getGlobalSearchPath();
                this._resourceLimitsProperties = this.getResourceLimitsProperties();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    protected LinkedList<String> getResourceLimits() {
        LinkedList<String> resourceLimits = new LinkedList<String>();
        if (this._resourceLimitsProperties == null) {
            return resourceLimits;
        }
        for (Object key : this._resourceLimitsProperties.keySet()) {
            String value = (String)this._resourceLimitsProperties.get(key);
            if (Validator.isNull((String)value)) continue;
            resourceLimits.add("-limit");
            resourceLimits.add((String)key);
            resourceLimits.add(value);
        }
        return resourceLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessExecutor _getProcessExecutor() {
        if (this._processExecutor != null) {
            return this._processExecutor;
        }
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            if (this._processExecutor == null) {
                this._processExecutor = new ProcessExecutor();
                this._processExecutor.setThreadFactory((ThreadFactory)new NamedThreadFactory(ImageMagickImpl.class.getName(), 1, ClassLoaderUtil.getPortalClassLoader()));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._processExecutor;
        }
    }
}

