/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.FreeMarkerTemplate;
import com.liferay.portal.freemarker.LiferayObjectWrapper;
import com.liferay.portal.freemarker.LiferayTemplateCache;
import com.liferay.portal.freemarker.LiferayTemplateClassResolver;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.template.BaseTemplateManager;
import com.liferay.portal.template.RestrictedTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.util.PropsValues;
import freemarker.core.TemplateClassResolver;
import freemarker.debug.impl.DebuggerService;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import java.lang.reflect.Field;
import java.util.Map;

@DoPrivileged
public class FreeMarkerManager
extends BaseTemplateManager {
    private Configuration _configuration;
    private TemplateContextHelper _templateContextHelper;

    public void destroy() {
        if (this._configuration == null) {
            return;
        }
        this._configuration.clearEncodingMap();
        this._configuration.clearSharedVariables();
        this._configuration.clearTemplateCache();
        this._configuration = null;
        this._templateContextHelper.removeAllHelperUtilities();
        this._templateContextHelper = null;
        if (this.isEnableDebuggerService()) {
            DebuggerService.shutdown();
        }
    }

    public void destroy(ClassLoader classLoader) {
        this._templateContextHelper.removeHelperUtilities(classLoader);
    }

    public String getName() {
        return "ftl";
    }

    public void init() throws TemplateException {
        if (this._configuration != null) {
            return;
        }
        this._configuration = new Configuration();
        try {
            Field field = ReflectionUtil.getDeclaredField(Configuration.class, (String)"cache");
            LiferayTemplateCache templateCache = new LiferayTemplateCache(this._configuration);
            field.set(this._configuration, (Object)templateCache);
        }
        catch (Exception exception) {
            throw new TemplateException("Unable to Initialize Freemarker manager");
        }
        this._configuration.setDefaultEncoding("UTF-8");
        this._configuration.setLocalizedLookup(PropsValues.FREEMARKER_ENGINE_LOCALIZED_LOOKUP);
        this._configuration.setNewBuiltinClassResolver((TemplateClassResolver)new LiferayTemplateClassResolver());
        this._configuration.setObjectWrapper((ObjectWrapper)new LiferayObjectWrapper());
        try {
            this._configuration.setSetting("auto_import", PropsValues.FREEMARKER_ENGINE_MACRO_LIBRARY);
            this._configuration.setSetting("template_exception_handler", PropsValues.FREEMARKER_ENGINE_TEMPLATE_EXCEPTION_HANDLER);
        }
        catch (Exception e2) {
            throw new TemplateException("Unable to init freemarker manager", (Throwable)e2);
        }
        if (this.isEnableDebuggerService()) {
            DebuggerService.getBreakpoints((String)"*");
        }
    }

    public void setTemplateContextHelper(TemplateContextHelper templateContextHelper) {
        this._templateContextHelper = templateContextHelper;
    }

    @Override
    protected Template doGetTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted, Map<String, Object> helperUtilities) {
        Object template = new FreeMarkerTemplate(templateResource, errorTemplateResource, helperUtilities, this._configuration, this._templateContextHelper);
        if (restricted) {
            template = new RestrictedTemplate((Template)template, this._templateContextHelper.getRestrictedVariables());
        }
        return template;
    }

    @Override
    protected TemplateContextHelper getTemplateContextHelper() {
        return this._templateContextHelper;
    }

    protected boolean isEnableDebuggerService() {
        return System.getProperty("freemarker.debug.password") != null && System.getProperty("freemarker.debug.port") != null;
    }
}

