/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.UpgradeProcessUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcessUtil;
import java.sql.Connection;

public class StartupHelper {
    private static Log _log = LogFactoryUtil.getLog(StartupHelper.class);
    private boolean _dropIndexes;
    private boolean _upgraded;
    private boolean _verified;

    public boolean isUpgraded() {
        return this._upgraded;
    }

    public boolean isVerified() {
        return this._verified;
    }

    public void setDropIndexes(boolean dropIndexes) {
        this._dropIndexes = dropIndexes;
    }

    public void updateIndexes() {
        this.updateIndexes(this._dropIndexes);
    }

    public void updateIndexes(boolean dropIndexes) {
        DB db = DBFactoryUtil.getDB();
        Connection connection = null;
        try {
            try {
                connection = DataAccess.getConnection();
                this.updateIndexes(db, connection, dropIndexes);
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e2, (Throwable)e2);
                }
                DataAccess.cleanUp((Connection)connection);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
    }

    public void updateIndexes(DB db, Connection connection, boolean dropIndexes) {
        block2: {
            try {
                ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
                String tablesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
                String indexesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.sql");
                String indexesProperties = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.properties");
                db.updateIndexes(connection, tablesSQL, indexesSQL, indexesProperties, dropIndexes);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    public void upgradeProcess(int buildNumber) throws UpgradeException {
        if (buildNumber == ReleaseInfo.getParentBuildNumber()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping upgrade process from " + buildNumber + " to " + ReleaseInfo.getParentBuildNumber()));
            }
            return;
        }
        String[] upgradeProcessClassNames = this.getUpgradeProcessClassNames("upgrade.processes");
        if (upgradeProcessClassNames.length == 0 && (upgradeProcessClassNames = this.getUpgradeProcessClassNames("upgrade.processes." + buildNumber)).length == 0) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Upgrading from " + buildNumber + " to " + ReleaseInfo.getParentBuildNumber() + " is not " + "supported"));
            }
            System.exit(0);
        }
        this._upgraded = UpgradeProcessUtil.upgradeProcess(buildNumber, upgradeProcessClassNames, ClassLoaderUtil.getPortalClassLoader());
    }

    public void verifyProcess(boolean verified) throws VerifyException {
        this._verified = VerifyProcessUtil.verifyProcess(this._upgraded, verified);
    }

    protected String[] getUpgradeProcessClassNames(String key) {
        return StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get(key)));
    }
}

