/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.jcr.JCRFactoryUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployDir;
import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployListener;
import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.util.BrowserLauncher;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jamwiki.Environment;

public class GlobalStartupAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(GlobalStartupAction.class);
    private static List<AutoDeployListener> _autoDeployListeners;
    private static List<HotDeployListener> _hotDeployListeners;

    public static List<AutoDeployListener> getAutoDeployListeners() {
        String[] autoDeployListenerClassNames;
        if (_autoDeployListeners != null) {
            return _autoDeployListeners;
        }
        ArrayList<AutoDeployListener> autoDeployListeners = new ArrayList<AutoDeployListener>();
        String[] stringArray = autoDeployListenerClassNames = PropsUtil.getArray("auto.deploy.listeners");
        int n = autoDeployListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String autoDeployListenerClassName = stringArray[n2];
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + autoDeployListenerClassName));
                }
                AutoDeployListener autoDeployListener = (AutoDeployListener)InstanceFactory.newInstance((String)autoDeployListenerClassName);
                autoDeployListeners.add(autoDeployListener);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
            ++n2;
        }
        _autoDeployListeners = autoDeployListeners;
        return _autoDeployListeners;
    }

    public static List<HotDeployListener> getHotDeployListeners() {
        String[] hotDeployListenerClassNames;
        if (_hotDeployListeners != null) {
            return _hotDeployListeners;
        }
        ArrayList<HotDeployListener> hotDeployListeners = new ArrayList<HotDeployListener>();
        String[] stringArray = hotDeployListenerClassNames = PropsUtil.getArray("hot.deploy.listeners");
        int n = hotDeployListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String hotDeployListenerClassName = stringArray[n2];
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + hotDeployListenerClassName));
                }
                HotDeployListener hotDeployListener = (HotDeployListener)InstanceFactory.newInstance((String)hotDeployListenerClassName);
                hotDeployListeners.add(hotDeployListener);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
            ++n2;
        }
        _hotDeployListeners = hotDeployListeners;
        return _hotDeployListeners;
    }

    public static List<SandboxDeployListener> getSandboxDeployListeners() {
        String[] sandboxDeployListenerClassNames;
        ArrayList<SandboxDeployListener> sandboxDeployListeners = new ArrayList<SandboxDeployListener>();
        String[] stringArray = sandboxDeployListenerClassNames = PropsUtil.getArray("sandbox.deploy.listeners");
        int n = sandboxDeployListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sandboxDeployListenerClassName = stringArray[n2];
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + sandboxDeployListenerClassName));
                }
                SandboxDeployListener sandboxDeployListener = (SandboxDeployListener)InstanceFactory.newInstance((String)sandboxDeployListenerClassName);
                sandboxDeployListeners.add(sandboxDeployListener);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
            ++n2;
        }
        return sandboxDeployListeners;
    }

    public void run(String[] ids) {
        block26: {
            File deployDir;
            try {
                if (PrefsPropsUtil.getBoolean("auto.deploy.enabled", PropsValues.AUTO_DEPLOY_ENABLED)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Registering auto deploy directories");
                    }
                    deployDir = new File(PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR));
                    File destDir = new File(DeployUtil.getAutoDeployDestDir());
                    long interval = PrefsPropsUtil.getLong("auto.deploy.interval", PropsValues.AUTO_DEPLOY_INTERVAL);
                    List<AutoDeployListener> autoDeployListeners = GlobalStartupAction.getAutoDeployListeners();
                    AutoDeployDir autoDeployDir = new AutoDeployDir("defaultAutoDeployDir", deployDir, destDir, interval, autoDeployListeners);
                    AutoDeployUtil.registerDir((AutoDeployDir)autoDeployDir);
                } else if (_log.isInfoEnabled()) {
                    _log.info((Object)"Not registering auto deploy directories");
                }
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Registering hot deploy listeners");
            }
            for (HotDeployListener hotDeployListener : GlobalStartupAction.getHotDeployListeners()) {
                HotDeployUtil.registerListener((HotDeployListener)hotDeployListener);
            }
            try {
                if (PrefsPropsUtil.getBoolean("sandbox.deploy.enabled", PropsValues.SANDBOX_DEPLOY_ENABLED)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Registering sandbox deploy directories");
                    }
                    deployDir = new File(PrefsPropsUtil.getString("sandbox.deploy.dir", PropsValues.SANDBOX_DEPLOY_DIR));
                    long interval = PrefsPropsUtil.getLong("sandbox.deploy.interval", PropsValues.SANDBOX_DEPLOY_INTERVAL);
                    List<SandboxDeployListener> sandboxDeployListeners = GlobalStartupAction.getSandboxDeployListeners();
                    SandboxDeployDir sandboxDeployDir = new SandboxDeployDir("defaultSandboxDeployDir", deployDir, interval, sandboxDeployListeners);
                    SandboxDeployUtil.registerDir((SandboxDeployDir)sandboxDeployDir);
                } else if (_log.isInfoEnabled()) {
                    _log.info((Object)"Not registering sandbox deploy directories");
                }
            }
            catch (Exception e3) {
                _log.error((Throwable)e3);
            }
            AuthPublicPathRegistry.register(PropsValues.AUTH_PUBLIC_PATHS);
            try {
                String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
                Environment.setValue((String)"homeDir", (String)tmpDir);
            }
            catch (Throwable t) {
                _log.error(t);
            }
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            JavadocManagerUtil.load((String)"", (ClassLoader)contextClassLoader);
            try {
                JCRFactoryUtil.prepare();
                if (GetterUtil.getBoolean((String)PropsUtil.get("jcr.initialize.on.startup"))) {
                    JCRFactoryUtil.initialize();
                }
            }
            catch (Exception e4) {
                _log.error((Throwable)e4);
            }
            try {
                InfrastructureUtil.getDataSource();
            }
            catch (Exception e5) {
                _log.error((Object)e5, (Throwable)e5);
            }
            try {
                if (!ServerDetector.isJOnAS()) {
                    InfrastructureUtil.getMailSession();
                }
            }
            catch (Exception e6) {
                if (!_log.isWarnEnabled()) break block26;
                _log.warn((Object)e6.getMessage());
            }
        }
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            POPServerUtil.start();
        }
        if (Validator.isNotNull((String)PropsValues.BROWSER_LAUNCHER_URL)) {
            Thread browserLauncherThread = new Thread(new BrowserLauncher());
            browserLauncherThread.start();
        }
    }
}

