/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class AddDefaultLayoutSetPrototypesAction
extends SimpleAction {
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(GetterUtil.getLong((String)ids[0]));
        }
        catch (Exception e2) {
            throw new ActionException((Throwable)e2);
        }
    }

    protected Layout addLayout(LayoutSet layoutSet, String name, String friendlyURL, String layouteTemplateId) throws Exception {
        Group group = layoutSet.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)group.getCreatorUserId(), (long)group.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)0L, (String)name, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, layouteTemplateId, false);
        return layout;
    }

    protected LayoutSet addLayoutSetPrototype(long companyId, long defaultUserId, String name, String description, List<LayoutSetPrototype> layoutSetPrototypes) throws Exception {
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            String curName = layoutSetPrototype.getName(LocaleUtil.getDefault());
            String curDescription = layoutSetPrototype.getDescription();
            if (!name.equals(curName) || !description.equals(curDescription)) continue;
            return null;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)defaultUserId, (long)companyId, nameMap, (String)description, (boolean)true, (boolean)true, (ServiceContext)new ServiceContext());
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (ServiceContext)serviceContext);
        return layoutSetPrototype.getLayoutSet();
    }

    protected String addPortletId(Layout layout, String portletId, String columnId) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        portletId = layoutTypePortlet.addPortletId(0L, portletId, columnId, -1, false);
        this.updateLayout(layout);
        this.addResourcePermissions(layout, portletId);
        return portletId;
    }

    protected void addPrivateSite(long companyId, long defaultUserId, List<LayoutSetPrototype> layoutSetPrototypes) throws Exception {
        LayoutSet layoutSet = this.addLayoutSetPrototype(companyId, defaultUserId, "Intranet Site", "Site with Documents and News", layoutSetPrototypes);
        if (layoutSet == null) {
            return;
        }
        Layout layout = this.addLayout(layoutSet, "Home", "/home", "2_columns_i");
        this.addPortletId(layout, "116", "column-1");
        String portletId = this.addPortletId(layout, "3", "column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("portletSetupShowBorders", Boolean.FALSE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "82", "column-2");
        preferences = new HashMap();
        preferences.put("displayStyle", "3");
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "101", "column-2");
        preferences = new HashMap();
        preferences.put("portletSetupTitle_" + LocaleUtil.getDefault(), "Recent Content");
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        layout = this.addLayout(layoutSet, "Documents and Media", "/documents", "1_column");
        portletId = this.addPortletId(layout, "20", "column-1");
        preferences = new HashMap();
        preferences.put("portletSetupShowBorders", Boolean.FALSE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "101", "column-2");
        preferences = new HashMap();
        preferences.put("anyAssetType", Boolean.FALSE.toString());
        preferences.put("portletSetupTitle_" + LocaleUtil.getDefault(), "Upcoming Events");
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        layout = this.addLayout(layoutSet, "News", "/news", "2_columns_iii");
        portletId = this.addPortletId(layout, "39", "column-1");
        preferences = new HashMap();
        preferences.put("expandedEntriesPerFeed", "3");
        preferences.put("portletSetupTitle_" + LocaleUtil.getDefault(), "Technology news");
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        preferences.put("urls", "http://partners.userland.com/nytRss/technology.xml");
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "39", "column-2");
        preferences = new HashMap();
        preferences.put("expandedEntriesPerFeed", "0");
        preferences.put("portletSetupTitle_" + LocaleUtil.getDefault(), "Liferay news");
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        preferences.put("urls", "http://www.liferay.com/en/about-us/news/-/blogs/rss");
        preferences.put("titles", "Liferay Press Releases");
        this.updatePortletSetup(layout, portletId, preferences);
    }

    protected void addPublicSite(long companyId, long defaultUserId, List<LayoutSetPrototype> layoutSetPrototypes) throws Exception {
        LayoutSet layoutSet = this.addLayoutSetPrototype(companyId, defaultUserId, "Community Site", "Site with Forums and Wiki", layoutSetPrototypes);
        if (layoutSet == null) {
            return;
        }
        Layout layout = this.addLayout(layoutSet, "Home", "/home", "2_columns_iii");
        this.addPortletId(layout, "19", "column-1");
        String portletId = this.addPortletId(layout, "3", "column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("portletSetupShowBorders", Boolean.FALSE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        this.addPortletId(layout, "59", "column-2");
        this.addPortletId(layout, "180", "column-2");
        portletId = this.addPortletId(layout, "101", "column-2");
        preferences = new HashMap();
        preferences.put("anyAssetType", Boolean.FALSE.toString());
        preferences.put("portletSetupTitle_" + LocaleUtil.getDefault(), "Upcoming Events");
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        layout = this.addLayout(layoutSet, "Wiki", "/wiki", "2_columns_iii");
        this.addPortletId(layout, "36", "column-1");
        this.addPortletId(layout, "122", "column-2");
        this.addPortletId(layout, "148", "column-2");
    }

    protected void addResourcePermissions(Layout layout, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        PortalUtil.addPortletDefaultResource((long)layout.getCompanyId(), (Layout)layout, (Portlet)portlet);
    }

    protected void doRun(long companyId) throws Exception {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        List layoutSetPrototypes = LayoutSetPrototypeLocalServiceUtil.search((long)companyId, null, (int)-1, (int)-1, null);
        this.addPublicSite(companyId, defaultUserId, layoutSetPrototypes);
        this.addPrivateSite(companyId, defaultUserId, layoutSetPrototypes);
    }

    protected void updateLayout(Layout layout) throws Exception {
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }

    protected PortletPreferences updatePortletSetup(Layout layout, String portletId, Map<String, String> preferences) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            portletSetup.setValue(key, value);
        }
        portletSetup.store();
        return portletSetup;
    }
}

