/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.util.ContentUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class AddDefaultDDMTemplatesAction
extends SimpleAction {
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(GetterUtil.getLong((String)ids[0]));
        }
        catch (Exception e2) {
            throw new ActionException((Throwable)e2);
        }
    }

    protected void addDDMTemplate(long userId, long groupId, long classNameId, String templateKey, String name, String description, String language, String scriptFileName, boolean cacheable, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)groupId, (long)classNameId, (String)templateKey);
        if (ddmTemplate != null) {
            return;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getDefault();
        nameMap.put(locale, LanguageUtil.get((Locale)locale, (String)name));
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, LanguageUtil.get((Locale)locale, (String)description));
        String script = ContentUtil.get((String)scriptFileName);
        DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)groupId, (long)classNameId, (long)0L, (String)templateKey, nameMap, descriptionMap, (String)"display", null, (String)language, (String)script, (boolean)cacheable, (boolean)false, null, null, (ServiceContext)serviceContext);
    }

    protected void addDDMTemplates(long userId, long groupId, ServiceContext serviceContext) throws Exception {
        List templateHandlers = TemplateHandlerRegistryUtil.getTemplateHandlers();
        for (TemplateHandler templateHandler : templateHandlers) {
            long classNameId = PortalUtil.getClassNameId((String)templateHandler.getClassName());
            List templateElements = templateHandler.getDefaultTemplateElements();
            for (Element templateElement : templateElements) {
                String templateKey = templateElement.elementText("template-key");
                DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)groupId, (long)classNameId, (String)templateKey);
                if (ddmTemplate != null) continue;
                String name = templateElement.elementText("name");
                String description = templateElement.elementText("description");
                String language = templateElement.elementText("language");
                String scriptFileName = templateElement.elementText("script-file");
                boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
                this.addDDMTemplate(userId, groupId, classNameId, templateKey, name, description, language, scriptFileName, cacheable, serviceContext);
            }
        }
    }

    protected void doRun(long companyId) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
        serviceContext.setScopeGroupId(group.getGroupId());
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        serviceContext.setUserId(defaultUserId);
        this.addDDMTemplates(defaultUserId, group.getGroupId(), serviceContext);
    }
}

