/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentCommandReceiver
extends BaseCommandReceiver {
    private static Log _log = LogFactoryUtil.getLog(DocumentCommandReceiver.class);

    @Override
    protected String createFolder(CommandArgument commandArgument) {
        try {
            Group group = commandArgument.getCurrentGroup();
            Folder folder = this._getFolder(group.getGroupId(), "/" + commandArgument.getCurrentFolder());
            long repositoryId = folder.getRepositoryId();
            long parentFolderId = folder.getFolderId();
            String name = commandArgument.getNewFolder();
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            DLAppServiceUtil.addFolder((long)repositoryId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
        return "0";
    }

    @Override
    protected String fileUpload(CommandArgument commandArgument, String fileName, InputStream inputStream, String contentType, long size) {
        try {
            Group group = commandArgument.getCurrentGroup();
            Folder folder = this._getFolder(group.getGroupId(), commandArgument.getCurrentFolder());
            long repositoryId = folder.getRepositoryId();
            long folderId = folder.getFolderId();
            String title = fileName;
            String description = "";
            String changeLog = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)title, (String)contentType, (String)title, (String)description, (String)changeLog, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
        return "0";
    }

    @Override
    protected void getFolders(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFolders(commandArgument, document, rootNode);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }

    @Override
    protected void getFoldersAndFiles(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFolders(commandArgument, document, rootNode);
            this._getFiles(commandArgument, document, rootNode);
        }
        catch (PrincipalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }

    @Override
    protected boolean isStagedData(Group group) {
        return group.isStagedPortlet("20");
    }

    private void _getFiles(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        Element filesElement = document.createElement("Files");
        rootNode.appendChild(filesElement);
        if (Validator.isNull((String)commandArgument.getCurrentGroupName())) {
            return;
        }
        Group group = commandArgument.getCurrentGroup();
        Folder folder = this._getFolder(group.getGroupId(), commandArgument.getCurrentFolder());
        List fileEntries = DLAppServiceUtil.getFileEntries((long)folder.getRepositoryId(), (long)folder.getFolderId());
        for (FileEntry fileEntry : fileEntries) {
            Element fileElement = document.createElement("File");
            filesElement.appendChild(fileElement);
            fileElement.setAttribute("name", fileEntry.getTitle());
            fileElement.setAttribute("desc", fileEntry.getTitle());
            fileElement.setAttribute("size", this.getSize(fileEntry.getSize()));
            ThemeDisplay themeDisplay = commandArgument.getThemeDisplay();
            String url = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (ThemeDisplay)themeDisplay, (String)"", (boolean)false, (boolean)false);
            fileElement.setAttribute("url", url);
        }
    }

    private Folder _getFolder(long groupId, String folderName) throws Exception {
        DLFolderImpl dlFolder = new DLFolderImpl();
        dlFolder.setFolderId(0L);
        dlFolder.setGroupId(groupId);
        dlFolder.setRepositoryId(groupId);
        LiferayFolder folder = new LiferayFolder(dlFolder);
        if (folderName.equals("/")) {
            return folder;
        }
        StringTokenizer st = new StringTokenizer(folderName, "/");
        block0: while (st.hasMoreTokens()) {
            String curFolderName = st.nextToken();
            List folders = DLAppServiceUtil.getFolders((long)folder.getRepositoryId(), (long)folder.getFolderId());
            for (Folder curFolder : folders) {
                if (!curFolder.getName().equals(curFolderName)) continue;
                folder = curFolder;
                continue block0;
            }
        }
        return folder;
    }

    private void _getFolders(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        Element foldersElement = document.createElement("Folders");
        rootNode.appendChild(foldersElement);
        if (commandArgument.getCurrentFolder().equals("/")) {
            this.getRootFolders(commandArgument, document, foldersElement);
        } else {
            Group group = commandArgument.getCurrentGroup();
            Folder folder = this._getFolder(group.getGroupId(), commandArgument.getCurrentFolder());
            List folders = DLAppServiceUtil.getFolders((long)folder.getRepositoryId(), (long)folder.getFolderId());
            for (Folder curFolder : folders) {
                Element folderElement = document.createElement("Folder");
                foldersElement.appendChild(folderElement);
                folderElement.setAttribute("name", curFolder.getName());
            }
        }
    }
}

