/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.theme.ThemeLoaderFactory;
import java.net.URL;
import javax.servlet.ServletContext;

public class ThemeLoaderHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(ThemeLoaderHotDeployListener.class);

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering theme loader for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering theme loader for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-theme-loader.xml"))})[0] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering theme loader for " + servletContextName));
        }
        ThemeLoaderFactory.init(servletContextName, servletContext, xmls);
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        boolean value;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if (!(value = ThemeLoaderFactory.destroy(servletContextName))) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unregistering theme loader for " + servletContextName));
        }
        ServletContextPool.remove((String)servletContextName);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Theme loader for " + servletContextName + " unregistered successfully"));
        }
    }
}

