/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.counter.service.persistence.CounterFinder;
import com.liferay.counter.service.persistence.CounterPersistence;
import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.dao.shard.ShardSessionFactoryTargetSource;
import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.persistence.ClassNamePersistence;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.PortalPreferencesPersistence;
import com.liferay.portal.service.persistence.ReleasePersistence;
import com.liferay.portal.service.persistence.ResourceActionPersistence;
import com.liferay.portal.service.persistence.ServiceComponentPersistence;
import com.liferay.portal.service.persistence.ShardPersistence;
import com.liferay.portal.service.persistence.VirtualHostPersistence;
import com.liferay.portal.util.PropsValues;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShardPersistenceAdvice
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(ShardPersistenceAdvice.class);
    private ShardAdvice _shardAdvice;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ShardDataSourceTargetSource shardDataSourceTargetSource = this._shardAdvice.getShardDataSourceTargetSource();
        ShardSessionFactoryTargetSource shardSessionFactoryTargetSource = this._shardAdvice.getShardSessionFactoryTargetSource();
        if (shardDataSourceTargetSource == null || shardSessionFactoryTargetSource == null) {
            return methodInvocation.proceed();
        }
        Object target = methodInvocation.getThis();
        if (target instanceof ClassNamePersistence || target instanceof CompanyPersistence || target instanceof CounterFinder || target instanceof CounterPersistence || target instanceof PortalPreferencesPersistence || target instanceof ReleasePersistence || target instanceof ResourceActionPersistence || target instanceof ServiceComponentPersistence || target instanceof ShardPersistence || target instanceof VirtualHostPersistence) {
            String currentShardName = ShardUtil.setTargetSource((String)PropsValues.SHARD_DEFAULT_NAME);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using default shard for " + methodInvocation.toString()));
            }
            this._shardAdvice.pushCompanyService(PropsValues.SHARD_DEFAULT_NAME);
            try {
                Object object = methodInvocation.proceed();
                return object;
            }
            finally {
                this._shardAdvice.popCompanyService();
                ShardUtil.setTargetSource((String)currentShardName);
            }
        }
        if (this._shardAdvice.getGlobalCall() == null) {
            String shardName = this._shardAdvice.setShardNameByCompany();
            ShardUtil.setTargetSource((String)shardName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using shard name " + shardName + " for " + methodInvocation.toString()));
            }
            return methodInvocation.proceed();
        }
        return methodInvocation.proceed();
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        this._shardAdvice = shardAdvice;
    }
}

