/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLServerLimitStringUtil {
    private static Pattern _columnAliasPattern = Pattern.compile("[\\w\\.]+(?:\\(.+?\\))? AS (\\w+)", 2);
    private static Pattern _distinctPattern = Pattern.compile(" DISTINCT ", 2);
    private static Pattern _qualifiedColumnPattern = Pattern.compile("\\w+\\.([\\w\\*]+)");
    private static Pattern _selectPattern = Pattern.compile("SELECT ", 2);

    public static String getLimitString(String sql, int offset, int limit) {
        String sqlLowerCase = sql.toLowerCase();
        int fromPos = sqlLowerCase.indexOf(" from ");
        String selectFrom = sql.substring(0, fromPos);
        int orderByPos = sqlLowerCase.lastIndexOf(" order by ");
        String selectFromWhere = null;
        String orderBy = "";
        if (orderByPos > 0) {
            selectFromWhere = sql.substring(fromPos, orderByPos);
            orderBy = sql.substring(orderByPos + 9);
        } else {
            selectFromWhere = sql.substring(fromPos);
        }
        String[] splitOrderBy = SQLServerLimitStringUtil._splitOrderBy(selectFrom, orderBy);
        String innerOrderBy = splitOrderBy[0];
        String outerOrderBy = splitOrderBy[1];
        String[] splitSelectFrom = SQLServerLimitStringUtil._splitSelectFrom(selectFrom, innerOrderBy, limit);
        String innerSelectFrom = splitSelectFrom[0];
        String outerSelectFrom = splitSelectFrom[1];
        StringBundler sb = new StringBundler(15);
        sb.append(outerSelectFrom);
        sb.append(" from (");
        sb.append(outerSelectFrom);
        sb.append(", row_number() over (");
        sb.append(outerOrderBy);
        sb.append(") as _page_row_num from (");
        sb.append(innerSelectFrom);
        sb.append(selectFromWhere);
        sb.append(innerOrderBy);
        sb.append(" ) _temp_table_1 ) _temp_table_2");
        sb.append(" where _page_row_num between ");
        sb.append(offset + 1);
        sb.append(" and ");
        sb.append(limit);
        sb.append(" order by _page_row_num");
        return sb.toString();
    }

    private static final String[] _splitOrderBy(String selectFrom, String orderBy) {
        String[] orderByColumns;
        StringBundler innerOrderBySB = new StringBundler();
        StringBundler outerOrderBySB = new StringBundler();
        String[] stringArray = orderByColumns = StringUtil.split((String)orderBy, (char)',');
        int n = orderByColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String patternString;
            Pattern pattern;
            Matcher matcher;
            int parenPos;
            String orderByColumn = stringArray[n2];
            String orderByColumnName = orderByColumn = orderByColumn.trim();
            String orderByType = "ASC";
            int spacePos = orderByColumn.lastIndexOf(32);
            if (spacePos != -1 && (parenPos = orderByColumn.indexOf(40, spacePos)) == -1) {
                orderByColumnName = orderByColumn.substring(0, spacePos);
                orderByType = orderByColumn.substring(spacePos + 1);
            }
            if ((matcher = (pattern = Pattern.compile(patternString = "\\Q".concat(orderByColumnName).concat("\\E as (\\w+)"), 2)).matcher(selectFrom)).find()) {
                orderByColumnName = matcher.group(1);
            }
            if (selectFrom.contains(orderByColumnName)) {
                if (outerOrderBySB.length() == 0) {
                    outerOrderBySB.append(" order by ");
                } else {
                    outerOrderBySB.append(",");
                }
                matcher = _qualifiedColumnPattern.matcher(orderByColumnName);
                orderByColumnName = matcher.replaceAll("$1");
                outerOrderBySB.append(orderByColumnName);
                outerOrderBySB.append(" ");
                outerOrderBySB.append(orderByType);
            } else {
                if (innerOrderBySB.length() == 0) {
                    innerOrderBySB.append(" order by ");
                } else {
                    innerOrderBySB.append(",");
                }
                innerOrderBySB.append(orderByColumnName);
                innerOrderBySB.append(" ");
                innerOrderBySB.append(orderByType);
            }
            ++n2;
        }
        if (outerOrderBySB.length() == 0) {
            outerOrderBySB.append(" order by CURRENT_TIMESTAMP");
        }
        return new String[]{innerOrderBySB.toString(), outerOrderBySB.toString()};
    }

    private static String[] _splitSelectFrom(String selectFrom, String innerOrderBy, int limit) {
        String innerSelectFrom = selectFrom;
        if (Validator.isNotNull((String)innerOrderBy)) {
            Matcher matcher = _selectPattern.matcher(innerSelectFrom);
            innerSelectFrom = matcher.replaceAll("select top ".concat(String.valueOf(limit)).concat(" "));
        }
        String outerSelectFrom = selectFrom;
        while (outerSelectFrom.charAt(0) == '(') {
            outerSelectFrom = outerSelectFrom.substring(1);
        }
        Matcher matcher = _columnAliasPattern.matcher(outerSelectFrom);
        outerSelectFrom = matcher.replaceAll("$1");
        matcher = _distinctPattern.matcher(outerSelectFrom);
        outerSelectFrom = matcher.replaceAll(" ");
        matcher = _qualifiedColumnPattern.matcher(outerSelectFrom);
        outerSelectFrom = matcher.replaceAll("$1");
        return new String[]{innerSelectFrom, outerSelectFrom};
    }
}

