/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.portal.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.dao.jdbc.aop.Operation;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.spring.transaction.TransactionInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class DynamicDataSourceTransactionInterceptor
extends TransactionInterceptor {
    private DynamicDataSourceTargetSource _dynamicDataSourceTargetSource;

    public void afterPropertiesSet() {
        if (this._dynamicDataSourceTargetSource == null) {
            this._dynamicDataSourceTargetSource = (DynamicDataSourceTargetSource)InfrastructureUtil.getDynamicDataSourceTargetSource();
        }
    }

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method targetMethod;
        TransactionAttribute transactionAttribute;
        if (this._dynamicDataSourceTargetSource == null) {
            return super.invoke(methodInvocation);
        }
        Class<?> targetClass = null;
        if (methodInvocation.getThis() != null) {
            Object thisObject = methodInvocation.getThis();
            targetClass = thisObject.getClass();
        }
        if ((transactionAttribute = this.transactionAttributeSource.getTransactionAttribute(targetMethod = methodInvocation.getMethod(), targetClass)) != null && transactionAttribute.isReadOnly()) {
            this._dynamicDataSourceTargetSource.setOperation(Operation.READ);
        } else {
            this._dynamicDataSourceTargetSource.setOperation(Operation.WRITE);
        }
        this._dynamicDataSourceTargetSource.pushMethod(targetClass.getName().concat(".").concat(targetMethod.getName()));
        Object returnValue = null;
        try {
            returnValue = super.invoke(methodInvocation);
        }
        finally {
            this._dynamicDataSourceTargetSource.popMethod();
        }
        return returnValue;
    }

    public void setDynamicDataSourceTargetSource(DynamicDataSourceTargetSource dynamicDataSourceTargetSource) {
        this._dynamicDataSourceTargetSource = dynamicDataSourceTargetSource;
    }
}

