/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class SybaseDB
extends BaseDB {
    protected static final String DROP_COLUMN = "drop column";
    private static final boolean _SUPPORTS_INLINE_DISTINCT = false;
    private static final String[] _SYBASE = new String[]{"--", "1", "0", "'19700101'", "getdate()", " image", " image", " int", " datetime", " float", " int", " decimal(20,0)", " varchar(1000)", " text", " varchar", "  identity(1,1)", "go"};
    private static SybaseDB _instance = new SybaseDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)");\n", (String)")\ngo\n");
        template = StringUtil.replace((String)template, (String)"\ngo;\n", (String)"\ngo\n");
        template = StringUtil.replace((String)template, (String[])new String[]{"\\\\", "\\'", "\\\"", "\\n", "\\r"}, (String[])new String[]{"\\", "''", "\"", "\n", "\r"});
        return template;
    }

    @Override
    public boolean isSupportsInlineDistinct() {
        return false;
    }

    protected SybaseDB() {
        super("sybase");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(19);
        sb.append("use master\n");
        sb.append("exec sp_dboption '");
        sb.append(databaseName);
        sb.append("', ");
        sb.append("'allow nulls by default' , true\n");
        sb.append("go\n\n");
        sb.append("exec sp_dboption '");
        sb.append(databaseName);
        sb.append("', ");
        sb.append("'select into/bulkcopy/pllsort' , true\n");
        sb.append("go\n\n");
        sb.append("use ");
        sb.append(databaseName);
        sb.append("\n\n");
        sb.append(this.getCreateTablesContent(sqlDir, suffix));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-sybase.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-sybase.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "sybase";
    }

    @Override
    protected String[] getTemplate() {
        return _SYBASE;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.contains(DROP_COLUMN)) {
                line = StringUtil.replace((String)line, (String)" drop column ", (String)" drop ");
            }
            if (line.startsWith("alter_column_name ")) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"exec sp_rename '@table@.@old-column@', '@new-column@', 'column';", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_column_type ")) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_table_name ")) {
                template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"exec sp_rename @old-table@, @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                String[] tokens = StringUtil.split((String)line, (char)' ');
                String tableName = tokens[4];
                if (tableName.endsWith(";")) {
                    tableName = tableName.substring(0, tableName.length() - 1);
                }
                line = StringUtil.replace((String)"drop index @table@.@index@;", (String)"@table@", (String)tableName);
                line = StringUtil.replace((String)line, (String)"@index@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

