/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SQLServerDB
extends BaseDB {
    private static final String[] _SQL_SERVER = new String[]{"--", "1", "0", "'19700101'", "GetDate()", " image", " image", " bit", " datetime", " float", " int", " bigint", " nvarchar(2000)", " nvarchar(max)", " nvarchar", "  identity(1,1)", "go"};
    private static final int _SQL_SERVER_2000 = 8;
    private static final boolean _SUPPORTS_ALTER_COLUMN_TYPE = false;
    private static SQLServerDB _instance = new SQLServerDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\ngo;\n", (String)"\ngo\n");
        template = StringUtil.replace((String)template, (String[])new String[]{"\\\\", "\\'", "\\\"", "\\n", "\\r"}, (String[])new String[]{"\\", "''", "\"", "\n", "\r"});
        return template;
    }

    @Override
    public List<Index> getIndexes(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        ArrayList<Index> indexes;
        block4: {
            indexes = new ArrayList<Index>();
            ps = null;
            rs = null;
            DatabaseMetaData databaseMetaData = con.getMetaData();
            if (databaseMetaData.getDatabaseMajorVersion() > 8) break block4;
            ArrayList<Index> arrayList = indexes;
            DataAccess.cleanUp(null, ps, rs);
            return arrayList;
        }
        try {
            StringBundler sb = new StringBundler(6);
            sb.append("select sys.tables.name as table_name, ");
            sb.append("sys.indexes.name as index_name, is_unique from ");
            sb.append("sys.indexes inner join sys.tables on ");
            sb.append("sys.tables.object_id = sys.indexes.object_id where ");
            sb.append("sys.indexes.name like 'LIFERAY_%' or sys.indexes.name ");
            sb.append("like 'IX_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                String tableName = rs.getString("table_name");
                boolean unique = !rs.getBoolean("is_unique");
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(null, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsAlterColumnType() {
        return false;
    }

    protected SQLServerDB() {
        super("sqlserver");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(17);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("\n");
        sb.append("go\n");
        sb.append("\n");
        sb.append("use ");
        sb.append(databaseName);
        sb.append(";\n\n");
        sb.append(this.getCreateTablesContent(sqlDir, suffix));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-sql-server.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-sql-server.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "sql-server";
    }

    @Override
    protected String[] getTemplate() {
        return _SQL_SERVER;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith("alter_column_name ")) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"exec sp_rename '@table@.@old-column@', '@new-column@', 'column';", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_column_type ")) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_table_name ")) {
                template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"exec sp_rename '@old-table@', '@new-table@';", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                String[] tokens = StringUtil.split((String)line, (char)' ');
                String tableName = tokens[4];
                if (tableName.endsWith(";")) {
                    tableName = tableName.substring(0, tableName.length() - 1);
                }
                line = StringUtil.replace((String)"drop index @table@.@index@;", (String)"@table@", (String)tableName);
                line = StringUtil.replace((String)line, (String)"@index@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

