/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PostgreSQLDB
extends BaseDB {
    private static final String[] _POSTGRESQL = new String[]{"--", "true", "false", "'01/01/1970'", "current_timestamp", " oid", " bytea", " bool", " timestamp", " double precision", " integer", " bigint", " text", " text", " varchar", "", "commit"};
    private static final boolean _SUPPORTS_QUERYING_AFTER_EXCEPTION = false;
    private static PostgreSQLDB _instance = new PostgreSQLDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        return template;
    }

    @Override
    public List<Index> getIndexes(Connection con) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBundler sb = new StringBundler(3);
            sb.append("select indexname, tablename, indexdef from pg_indexes ");
            sb.append("where indexname like 'liferay_%' or indexname like ");
            sb.append("'ix_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("indexname");
                String tableName = rs.getString("tablename");
                String indexSQL = rs.getString("indexdef").toLowerCase().trim();
                boolean unique = true;
                if (indexSQL.startsWith("create index ")) {
                    unique = false;
                }
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(null, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsQueryingAfterException() {
        return false;
    }

    protected PostgreSQLDB() {
        super("postgresql");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(14);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" encoding = 'UNICODE';\n");
        sb.append("\\c ");
        sb.append(databaseName);
        sb.append(";\n\n");
        sb.append(this.getCreateTablesContent(sqlDir, suffix));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-postgresql.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-postgresql.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "postgresql";
    }

    @Override
    protected String[] getTemplate() {
        return _POSTGRESQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] tokens;
            String[] template;
            if (line.startsWith("alter_column_name ")) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ rename @old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_column_type ")) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter @old-column@ type @type@ using @old-column@::@type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_table_name ")) {
                template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            } else if (line.contains("drop primary key")) {
                tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"alter table @table@ drop constraint @table@_pkey;", (String)"@table@", (String)tokens[2]);
            } else if (line.contains("\\'")) {
                line = StringUtil.replace((String)line, (String)"\\'", (String)"''");
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

