/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class InformixDB
extends BaseDB {
    private static final String[] _INFORMIX_TEMPLATE = new String[]{"--", "'T'", "'F'", "'1970-01-01'", "CURRENT YEAR TO FRACTION", " blob", " blob", " boolean", " datetime YEAR TO FRACTION", " float", " int", " int8", " lvarchar", " text", " varchar", "", "commit"};
    private static InformixDB _instance = new InformixDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeNull(template);
        return template;
    }

    protected InformixDB() {
        super("informix");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(22);
        sb.append("database sysmaster;\n");
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" WITH LOG;\n");
        sb.append("\n");
        sb.append("create procedure 'lportal'.isnull(test_string varchar)\n");
        sb.append("returning boolean;\n");
        sb.append("IF test_string IS NULL THEN\n");
        sb.append("\tRETURN 't';\n");
        sb.append("ELSE\n");
        sb.append("\tRETURN 'f';\n");
        sb.append("END IF\n");
        sb.append("end procedure;\n");
        sb.append("\n\n");
        sb.append(this.getCreateTablesContent(sqlDir, suffix));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-informix.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-informix.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "informix";
    }

    @Override
    protected String[] getTemplate() {
        return _INFORMIX_TEMPLATE;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        boolean createTable = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith("alter_column_name ")) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"rename column @table@.@old-column@ TO @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_column_type ")) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ modify (@old-column@ @type@);", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_table_name ")) {
                template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"rename table @old-table@ to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                String[] tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            } else if (line.indexOf("typeSettings text") > 0) {
                line = StringUtil.replace((String)line, (String)"typeSettings text", (String)"typeSettings lvarchar(4096)");
            } else if (line.indexOf("varchar(300)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(300)", (String)"lvarchar(300)");
            } else if (line.indexOf("varchar(500)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(500)", (String)"lvarchar(500)");
            } else if (line.indexOf("varchar(1000)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(1000)", (String)"lvarchar(1000)");
            } else if (line.indexOf("varchar(1024)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(1024)", (String)"lvarchar(1024)");
            } else if (line.indexOf("1970-01-01") > 0) {
                line = StringUtil.replace((String)line, (String)"1970-01-01", (String)"1970-01-01 00:00:00.0");
            } else if (line.contains("create table")) {
                createTable = true;
            } else if (line.contains(");") && createTable) {
                line = StringUtil.replace((String)line, (String)");", (String)")\nextent size 16 next size 16\nlock mode row;");
                createTable = false;
            } else if (line.contains("commit;")) {
                line = "";
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

