/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.portal.convert.ConvertException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.MaintenanceUtil;
import org.apache.commons.lang.time.StopWatch;

public abstract class ConvertProcess {
    private static Log _log = LogFactoryUtil.getLog(ConvertProcess.class);
    private String[] _paramValues = null;

    public void convert() throws ConvertException {
        try {
            if (this.getPath() != null) {
                return;
            }
            try {
                StopWatch stopWatch = null;
                if (_log.isInfoEnabled()) {
                    stopWatch = new StopWatch();
                    stopWatch.start();
                    _log.info((Object)("Starting conversion for " + this.getClass().getName()));
                }
                this.doConvert();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Finished conversion for " + this.getClass().getName() + " in " + stopWatch.getTime() + " ms"));
                }
            }
            catch (Exception e2) {
                throw new ConvertException(e2);
            }
        }
        finally {
            this.setParameterValues(null);
            MaintenanceUtil.cancel();
        }
    }

    public abstract String getDescription();

    public String getParameterDescription() {
        return null;
    }

    public String[] getParameterNames() {
        return null;
    }

    public String[] getParameterValues() {
        return this._paramValues;
    }

    public String getPath() {
        return null;
    }

    public abstract boolean isEnabled();

    public void setParameterValues(String[] values) {
        this._paramValues = values;
    }

    protected abstract void doConvert() throws Exception;
}

