/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.util.ClassLoaderUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;

public class ClusterableAdvice
extends AnnotationChainableMethodAdvice<Clusterable> {
    private static Log _log = LogFactoryUtil.getLog(ClusterableAdvice.class);
    private static MethodKey _invokeMethodKey = new MethodKey(ClusterableAdvice.class, "_invoke", new Class[]{MethodHandler.class, String.class, String.class, Class.class, Map.class});
    private static Clusterable _nullClusterable = new Clusterable(){

        public Class<? extends ClusterInvokeAcceptor> acceptor() {
            return null;
        }

        public Class<? extends Annotation> annotationType() {
            return Clusterable.class;
        }
    };

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodInvocation);
        if (clusterable == _nullClusterable) {
            return;
        }
        Object thisObject = methodInvocation.getThis();
        if (!(thisObject instanceof IdentifiableBean)) {
            _log.error((Object)("Not clustering calls for " + thisObject.getClass().getName() + " because it does not implement " + IdentifiableBean.class.getName()));
            return;
        }
        MethodHandler methodHandler = this.createMethodHandler(clusterable.acceptor(), methodInvocation);
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)methodHandler, (boolean)true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }

    @Override
    public Clusterable getNullAnnotation() {
        return _nullClusterable;
    }

    protected MethodHandler createMethodHandler(Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, MethodInvocation methodInvocation) {
        if (clusterInvokeAcceptorClass == ClusterInvokeAcceptor.class) {
            clusterInvokeAcceptorClass = null;
        }
        MethodHandler methodHandler = new MethodHandler(methodInvocation.getMethod(), methodInvocation.getArguments());
        Object thisObject = methodInvocation.getThis();
        IdentifiableBean identifiableBean = (IdentifiableBean)thisObject;
        String beanIdentifier = identifiableBean.getBeanIdentifier();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        String servletContextName = ClassLoaderPool.getContextName((ClassLoader)contextClassLoader);
        Map<String, Serializable> context = ClusterableContextThreadLocal.collectThreadLocalContext();
        return new MethodHandler(_invokeMethodKey, new Object[]{methodHandler, beanIdentifier, servletContextName, clusterInvokeAcceptorClass, context});
    }

    private static Object _invoke(MethodHandler methodHandler, String servletContextName, String beanIdentifier, Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, Map<String, Serializable> context) throws Exception {
        if (clusterInvokeAcceptorClass != null) {
            ClusterInvokeAcceptor clusterInvokeAcceptor;
            Constructor<? extends ClusterInvokeAcceptor> constructor = clusterInvokeAcceptorClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            if (!(clusterInvokeAcceptor = constructor.newInstance(new Object[0])).accept(context)) {
                return null;
            }
        }
        if (servletContextName == null) {
            if (Validator.isNull((String)beanIdentifier)) {
                return methodHandler.invoke(true);
            }
            Object bean = PortalBeanLocatorUtil.locate((String)beanIdentifier);
            return methodHandler.invoke(bean);
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoader classLoader = (ClassLoader)PortletBeanLocatorUtil.locate((String)servletContextName, (String)"portletClassLoader");
            ClassLoaderUtil.setContextClassLoader(classLoader);
            if (Validator.isNull((String)beanIdentifier)) {
                Object object = methodHandler.invoke(true);
                return object;
            }
            Object bean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)beanIdentifier);
            Object object = methodHandler.invoke(bean);
            return object;
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }
}

