/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.ClusterBase;
import com.liferay.portal.cluster.ClusterRequestReceiver;
import com.liferay.portal.cluster.DebuggingClusterEventListenerImpl;
import com.liferay.portal.cluster.LiveUsersClusterEventListenerImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.WeakValueConcurrentHashMap;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PortalPortEventListener;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.JChannel;

@DoPrivileged
public class ClusterExecutorImpl
extends ClusterBase
implements ClusterExecutor,
PortalPortEventListener {
    public static final String CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL = "CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL";
    private static final String _DEFAULT_CLUSTER_NAME = "LIFERAY-CONTROL-CHANNEL";
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorImpl.class);
    private CopyOnWriteArrayList<ClusterEventListener> _clusterEventListeners = new CopyOnWriteArrayList();
    private Map<String, Address> _clusterNodeAddresses = new ConcurrentHashMap<String, Address>();
    private JChannel _controlJChannel;
    private ExecutorService _executorService;
    private Map<String, FutureClusterResponses> _futureClusterResponses = new WeakValueConcurrentHashMap();
    private Map<Address, ClusterNode> _liveInstances = new ConcurrentHashMap<Address, ClusterNode>();
    private Address _localAddress;
    private ClusterNode _localClusterNode;
    private boolean _shortcutLocalMethod;

    public void addClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addIfAbsent(clusterEventListener);
    }

    @Override
    public void afterPropertiesSet() {
        if (PropsValues.CLUSTER_EXECUTOR_DEBUG_ENABLED) {
            this.addClusterEventListener(new DebuggingClusterEventListenerImpl());
        }
        if (PropsValues.LIVE_USERS_ENABLED) {
            this.addClusterEventListener(new LiveUsersClusterEventListenerImpl());
        }
        super.afterPropertiesSet();
    }

    @Override
    public void destroy() {
        if (!this.isEnabled()) {
            return;
        }
        PortalExecutorManagerUtil.shutdown((String)CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL, (boolean)true);
        this._controlJChannel.setReceiver(null);
        this._controlJChannel.close();
        this._clusterEventListeners.clear();
        this._clusterNodeAddresses.clear();
        this._futureClusterResponses.clear();
        this._liveInstances.clear();
        this._localAddress = null;
        this._localClusterNode = null;
    }

    public FutureClusterResponses execute(ClusterRequest clusterRequest) throws SystemException {
        if (!this.isEnabled()) {
            return null;
        }
        List<Address> addresses = this.prepareAddresses(clusterRequest);
        FutureClusterResponses futureClusterResponses = new FutureClusterResponses(addresses);
        if (!clusterRequest.isFireAndForget()) {
            String uuid = clusterRequest.getUuid();
            this._futureClusterResponses.put(uuid, futureClusterResponses);
        }
        if (this._shortcutLocalMethod && addresses.remove(this.getLocalClusterNodeAddress())) {
            this.runLocalMethod(clusterRequest, futureClusterResponses);
        }
        if (clusterRequest.isMulticast()) {
            try {
                this._controlJChannel.send(null, (Object)clusterRequest);
            }
            catch (Exception e2) {
                throw new SystemException("Unable to send multicast request", (Throwable)e2);
            }
        } else {
            for (Address address : addresses) {
                org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
                try {
                    this._controlJChannel.send(jGroupsAddress, (Object)clusterRequest);
                }
                catch (Exception e3) {
                    throw new SystemException("Unable to send unicast request", (Throwable)e3);
                }
            }
        }
        return futureClusterResponses;
    }

    public void execute(ClusterRequest clusterRequest, ClusterResponseCallback clusterResponseCallback) throws SystemException {
        FutureClusterResponses futureClusterResponses = this.execute(clusterRequest);
        ClusterResponseCallbackJob clusterResponseCallbackJob = new ClusterResponseCallbackJob(clusterResponseCallback, futureClusterResponses);
        this._executorService.execute(clusterResponseCallbackJob);
    }

    public void execute(ClusterRequest clusterRequest, ClusterResponseCallback clusterResponseCallback, long timeout, TimeUnit timeUnit) throws SystemException {
        FutureClusterResponses futureClusterResponses = this.execute(clusterRequest);
        ClusterResponseCallbackJob clusterResponseCallbackJob = new ClusterResponseCallbackJob(clusterResponseCallback, futureClusterResponses, timeout, timeUnit);
        this._executorService.execute(clusterResponseCallbackJob);
    }

    public List<ClusterEventListener> getClusterEventListeners() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._clusterEventListeners);
    }

    public List<Address> getClusterNodeAddresses() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return this.getAddresses(this._controlJChannel);
    }

    public List<ClusterNode> getClusterNodes() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return new ArrayList<ClusterNode>(this._liveInstances.values());
    }

    public ClusterNode getLocalClusterNode() {
        if (!this.isEnabled()) {
            return null;
        }
        return this._localClusterNode;
    }

    public Address getLocalClusterNodeAddress() {
        if (!this.isEnabled()) {
            return null;
        }
        return this._localAddress;
    }

    public void initialize() {
        if (!this.isEnabled()) {
            return;
        }
        this._executorService = PortalExecutorManagerUtil.getPortalExecutor((String)CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL);
        PortalUtil.addPortalPortEventListener((PortalPortEventListener)this);
        this._localAddress = new AddressImpl(this._controlJChannel.getAddress());
        try {
            this.initLocalClusterNode();
            this.memberJoined(this._localAddress, this._localClusterNode);
            this.sendNotifyRequest();
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to determine local network address", (Throwable)e2);
        }
        ClusterRequestReceiver clusterRequestReceiver = (ClusterRequestReceiver)this._controlJChannel.getReceiver();
        clusterRequestReceiver.openLatch();
    }

    public boolean isClusterNodeAlive(Address address) {
        if (!this.isEnabled()) {
            return false;
        }
        List<Address> addresses = this.getAddresses(this._controlJChannel);
        return addresses.contains(address);
    }

    public boolean isClusterNodeAlive(String clusterNodeId) {
        if (!this.isEnabled()) {
            return false;
        }
        return this._clusterNodeAddresses.containsKey(clusterNodeId);
    }

    public void portalPortConfigured(int port) {
        if (!this.isEnabled() || this._localClusterNode.getPort() == PropsValues.PORTAL_INSTANCE_HTTP_PORT) {
            return;
        }
        try {
            this._localClusterNode.setPort(port);
            this.memberJoined(this._localAddress, this._localClusterNode);
            ClusterRequest clusterRequest = ClusterRequest.createClusterRequest((ClusterMessageType)ClusterMessageType.UPDATE, (ClusterNode)this._localClusterNode);
            this._controlJChannel.send(null, (Object)clusterRequest);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to determine configure node port", (Throwable)e2);
        }
    }

    public void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.remove(clusterEventListener);
    }

    public void setClusterEventListeners(List<ClusterEventListener> clusterEventListeners) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addAllAbsent(clusterEventListeners);
    }

    public void setShortcutLocalMethod(boolean shortcutLocalMethod) {
        if (!this.isEnabled()) {
            return;
        }
        this._shortcutLocalMethod = shortcutLocalMethod;
    }

    protected void fireClusterEvent(ClusterEvent clusterEvent) {
        for (ClusterEventListener listener : this._clusterEventListeners) {
            listener.processClusterEvent(clusterEvent);
        }
    }

    protected ClusterNodeResponse generateClusterNodeResponse(ClusterRequest clusterRequest, Object returnValue, Exception exception) {
        ClusterNodeResponse clusterNodeResponse = new ClusterNodeResponse();
        clusterNodeResponse.setAddress(this.getLocalClusterNodeAddress());
        clusterNodeResponse.setClusterNode(this.getLocalClusterNode());
        clusterNodeResponse.setClusterMessageType(clusterRequest.getClusterMessageType());
        clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
        clusterNodeResponse.setUuid(clusterRequest.getUuid());
        if (exception != null) {
            clusterNodeResponse.setException(exception);
        } else if (returnValue instanceof Serializable) {
            clusterNodeResponse.setResult(returnValue);
        } else if (returnValue != null) {
            clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
        }
        return clusterNodeResponse;
    }

    protected JChannel getControlChannel() {
        return this._controlJChannel;
    }

    protected FutureClusterResponses getExecutionResults(String uuid) {
        return this._futureClusterResponses.get(uuid);
    }

    @Override
    protected void initChannels() throws Exception {
        Properties controlProperties = PropsUtil.getProperties("cluster.link.channel.properties.control", false);
        String controlProperty = controlProperties.getProperty("cluster.link.channel.properties.control");
        ClusterRequestReceiver clusterRequestReceiver = new ClusterRequestReceiver(this);
        this._controlJChannel = this.createJChannel(controlProperty, clusterRequestReceiver, _DEFAULT_CLUSTER_NAME);
    }

    protected void initLocalClusterNode() throws Exception {
        InetAddress inetAddress = this.bindInetAddress;
        if (inetAddress == null) {
            inetAddress = InetAddressUtil.getLocalInetAddress();
        }
        ClusterNode localClusterNode = new ClusterNode(PortalUUIDUtil.generate(), inetAddress);
        if (PropsValues.PORTAL_INSTANCE_HTTP_PORT > 0) {
            localClusterNode.setPort(PropsValues.PORTAL_INSTANCE_HTTP_PORT);
        } else {
            localClusterNode.setPort(PortalUtil.getPortalPort((boolean)false));
        }
        this._localClusterNode = localClusterNode;
    }

    protected boolean isShortcutLocalMethod() {
        return this._shortcutLocalMethod;
    }

    protected void memberJoined(Address joinAddress, ClusterNode clusterNode) {
        this._liveInstances.put(joinAddress, clusterNode);
        Address previousAddress = this._clusterNodeAddresses.put(clusterNode.getClusterNodeId(), joinAddress);
        if (previousAddress == null && !this._localAddress.equals(joinAddress)) {
            ClusterEvent clusterEvent = ClusterEvent.join((ClusterNode[])new ClusterNode[]{clusterNode});
            this.fireClusterEvent(clusterEvent);
        }
    }

    protected void memberRemoved(List<Address> departAddresses) {
        ArrayList<ClusterNode> departClusterNodes = new ArrayList<ClusterNode>();
        for (Address departAddress : departAddresses) {
            ClusterNode departClusterNode = this._liveInstances.remove(departAddress);
            if (departClusterNode == null) continue;
            departClusterNodes.add(departClusterNode);
            this._clusterNodeAddresses.remove(departClusterNode.getClusterNodeId());
        }
        if (departClusterNodes.isEmpty()) {
            return;
        }
        ClusterEvent clusterEvent = ClusterEvent.depart(departClusterNodes);
        this.fireClusterEvent(clusterEvent);
    }

    protected List<Address> prepareAddresses(ClusterRequest clusterRequest) {
        boolean isMulticast = clusterRequest.isMulticast();
        ArrayList<Address> addresses = null;
        if (isMulticast) {
            addresses = this.getAddresses(this._controlJChannel);
        } else {
            Collection clusterNodeIds;
            addresses = new ArrayList();
            Collection clusterNodeAddresses = clusterRequest.getTargetClusterNodeAddresses();
            if (clusterNodeAddresses != null) {
                addresses.addAll(clusterNodeAddresses);
            }
            if ((clusterNodeIds = clusterRequest.getTargetClusterNodeIds()) != null) {
                for (String clusterNodeId : clusterNodeIds) {
                    Address address = this._clusterNodeAddresses.get(clusterNodeId);
                    addresses.add(address);
                }
            }
        }
        if (clusterRequest.isSkipLocal()) {
            addresses.remove(this.getLocalClusterNodeAddress());
        }
        return addresses;
    }

    protected void runLocalMethod(ClusterRequest clusterRequest, FutureClusterResponses futureClusterResponses) {
        MethodHandler methodHandler = clusterRequest.getMethodHandler();
        Object returnValue = null;
        Exception exception = null;
        if (methodHandler == null) {
            exception = new ClusterException("Payload is not of type " + MethodHandler.class.getName());
        } else {
            try {
                returnValue = methodHandler.invoke(true);
            }
            catch (Exception e2) {
                exception = e2;
            }
        }
        if (!clusterRequest.isFireAndForget()) {
            ClusterNodeResponse clusterNodeResponse = this.generateClusterNodeResponse(clusterRequest, returnValue, exception);
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        }
    }

    protected void sendNotifyRequest() {
        ClusterRequest clusterRequest = ClusterRequest.createClusterRequest((ClusterMessageType)ClusterMessageType.NOTIFY, (ClusterNode)this._localClusterNode);
        try {
            this._controlJChannel.send(null, (Object)clusterRequest);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to send notify message", (Throwable)e2);
        }
    }

    private class ClusterResponseCallbackJob
    implements Runnable {
        private final ClusterResponseCallback _clusterResponseCallback;
        private final FutureClusterResponses _futureClusterResponses;
        private final long _timeout;
        private final boolean _timeoutGet;
        private final TimeUnit _timeUnit;

        public ClusterResponseCallbackJob(ClusterResponseCallback clusterResponseCallback, FutureClusterResponses futureClusterResponses) {
            this._clusterResponseCallback = clusterResponseCallback;
            this._futureClusterResponses = futureClusterResponses;
            this._timeout = -1L;
            this._timeoutGet = false;
            this._timeUnit = TimeUnit.SECONDS;
        }

        public ClusterResponseCallbackJob(ClusterResponseCallback clusterResponseCallback, FutureClusterResponses futureClusterResponses, long timeout, TimeUnit timeUnit) {
            this._clusterResponseCallback = clusterResponseCallback;
            this._futureClusterResponses = futureClusterResponses;
            this._timeout = timeout;
            this._timeoutGet = true;
            this._timeUnit = timeUnit;
        }

        @Override
        public void run() {
            BlockingQueue blockingQueue = this._futureClusterResponses.getPartialResults();
            this._clusterResponseCallback.callback(blockingQueue);
            ClusterNodeResponses clusterNodeResponses = null;
            try {
                clusterNodeResponses = this._timeoutGet ? this._futureClusterResponses.get(this._timeout, this._timeUnit) : this._futureClusterResponses.get();
                this._clusterResponseCallback.callback(clusterNodeResponses);
            }
            catch (InterruptedException ie) {
                this._clusterResponseCallback.processInterruptedException(ie);
            }
            catch (TimeoutException te) {
                this._clusterResponseCallback.processTimeoutException(te);
            }
        }
    }
}

