/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.transactional;

import com.liferay.portal.cache.transactional.TransactionalPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalPortalCacheHelper {
    private static ThreadLocal<List<PortalCacheMap>> _portalCacheMapsThreadLocal = new InitialThreadLocal(String.valueOf(TransactionalPortalCacheHelper.class.getName()) + "._portalCacheMapsThreadLocal", new ArrayList());

    public static void begin() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return;
        }
        TransactionalPortalCacheHelper._pushPortalCacheMap();
    }

    public static void commit() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return;
        }
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._popPortalCacheMap();
        for (Map.Entry portalCacheMapEntry : portalCacheMap.entrySet()) {
            PortalCache portalCache = (PortalCache)portalCacheMapEntry.getKey();
            UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMapEntry.getValue();
            uncommittedBuffer.commitTo((PortalCache<Serializable, Object>)portalCache);
        }
        portalCacheMap.clear();
    }

    public static boolean isEnabled() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return false;
        }
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return !portalCacheMaps.isEmpty();
    }

    public static void rollback() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return;
        }
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._popPortalCacheMap();
        portalCacheMap.clear();
    }

    protected static <K extends Serializable, V> V get(PortalCache<K, V> portalCache, K key) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            return null;
        }
        return (V)uncommittedBuffer.get(key);
    }

    protected static <K extends Serializable, V> void put(PortalCache<K, V> portalCache, K key, V value) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            uncommittedBuffer = new UncommittedBuffer();
            portalCacheMap.put(portalCache, uncommittedBuffer);
        }
        uncommittedBuffer.put(key, value);
    }

    protected static <K extends Serializable, V> void removeAll(PortalCache<K, V> portalCache) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            uncommittedBuffer = new UncommittedBuffer();
            portalCacheMap.put(portalCache, uncommittedBuffer);
        }
        uncommittedBuffer.removeAll();
    }

    private static PortalCacheMap _peekPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return portalCacheMaps.get(portalCacheMaps.size() - 1);
    }

    private static PortalCacheMap _popPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return portalCacheMaps.remove(portalCacheMaps.size() - 1);
    }

    private static void _pushPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        portalCacheMaps.add(new PortalCacheMap());
    }

    private static class PortalCacheMap
    extends HashMap<PortalCache<? extends Serializable, ?>, UncommittedBuffer> {
        private PortalCacheMap() {
        }
    }

    private static class UncommittedBuffer {
        private boolean _removeAll;
        private Map<Serializable, Object> _uncommittedMap = new HashMap<Serializable, Object>();

        private UncommittedBuffer() {
        }

        public void commitTo(PortalCache<Serializable, Object> portalCache) {
            if (this._removeAll) {
                portalCache.removeAll();
            }
            for (Map.Entry<Serializable, Object> entry : this._uncommittedMap.entrySet()) {
                Serializable key = entry.getKey();
                Object value = entry.getValue();
                if (value == TransactionalPortalCache.NULL_HOLDER) {
                    portalCache.remove(key);
                    continue;
                }
                portalCache.put(entry.getKey(), entry.getValue());
            }
        }

        public Object get(Serializable key) {
            Object value = this._uncommittedMap.get(key);
            if (value == null && this._removeAll) {
                value = TransactionalPortalCache.NULL_HOLDER;
            }
            return value;
        }

        public void put(Serializable key, Object value) {
            this._uncommittedMap.put(key, value);
        }

        public void removeAll() {
            this._uncommittedMap.clear();
            this._removeAll = true;
        }
    }
}

