/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class PortalCacheCacheEventListener<K extends Serializable, V>
implements CacheEventListener {
    private static Log _log = LogFactoryUtil.getLog(PortalCacheCacheEventListener.class);
    private CacheListener<K, V> _cacheListener;
    private PortalCache<K, V> _portalCache;

    public PortalCacheCacheEventListener(CacheListener<K, V> cacheListener, PortalCache<K, V> portalCache) {
        this._cacheListener = cacheListener;
        this._portalCache = portalCache;
    }

    public Object clone() {
        return new PortalCacheCacheEventListener<K, V>(this._cacheListener, this._portalCache);
    }

    public void dispose() {
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
        Serializable key = element.getKey();
        Object value = element.getObjectValue();
        this._cacheListener.notifyEntryEvicted(this._portalCache, key, value);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Evicted " + key + " from " + ehcache.getName()));
        }
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
        Serializable key = element.getKey();
        Object value = element.getObjectValue();
        this._cacheListener.notifyEntryExpired(this._portalCache, key, value);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expired " + key + " from " + ehcache.getName()));
        }
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        Serializable key = element.getKey();
        Object value = element.getObjectValue();
        this._cacheListener.notifyEntryPut(this._portalCache, key, value);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Inserted " + key + " into " + ehcache.getName()));
        }
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        Serializable key = element.getKey();
        Object value = element.getObjectValue();
        this._cacheListener.notifyEntryRemoved(this._portalCache, key, value);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Removed " + key + " from " + ehcache.getName()));
        }
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        Serializable key = element.getKey();
        Object value = element.getObjectValue();
        this._cacheListener.notifyEntryUpdated(this._portalCache, key, value);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updated " + key + " in " + ehcache.getName()));
        }
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        this._cacheListener.notifyRemoveAll(this._portalCache);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Cleared " + ehcache.getName()));
        }
    }
}

