/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcacheConfigurationUtil;
import com.liferay.portal.cache.ehcache.EhcachePortalCache;
import com.liferay.portal.dao.orm.common.EntityCacheImpl;
import com.liferay.portal.dao.orm.common.FinderCacheImpl;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.util.FailSafeTimer;

public class EhcachePortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    private static final String _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE = "/ehcache/liferay-multi-vm-clustered.xml";
    private static Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private CacheManager _cacheManager;
    private boolean _clusterAware;
    private String _configPropertyKey;
    private Map<String, EhcachePortalCache<K, V>> _ehcachePortalCaches = new HashMap<String, EhcachePortalCache<K, V>>();
    private ManagementService _managementService;
    private MBeanServer _mBeanServer;
    private boolean _mpiOnly;
    private boolean _registerCacheConfigurations = true;
    private boolean _registerCacheManager = true;
    private boolean _registerCaches = true;
    private boolean _registerCacheStatistics = true;
    private boolean _usingDefault;

    public void afterPropertiesSet() {
        if (this._cacheManager != null || this._mpiOnly && SPIUtil.isSPI()) {
            return;
        }
        String configurationPath = PropsUtil.get(this._configPropertyKey);
        if (Validator.isNull((String)configurationPath)) {
            configurationPath = _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE;
        }
        this._usingDefault = configurationPath.equals(_DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE);
        Configuration configuration = EhcacheConfigurationUtil.getConfiguration(configurationPath, this._clusterAware, this._usingDefault);
        this._cacheManager = new CacheManager(configuration);
        FailSafeTimer failSafeTimer = this._cacheManager.getTimer();
        failSafeTimer.cancel();
        try {
            Field cacheManagerTimerField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"cacheManagerTimer");
            cacheManagerTimerField.set(this._cacheManager, null);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        if (PropsValues.EHCACHE_PORTAL_CACHE_MANAGER_JMX_ENABLED) {
            this._managementService = new ManagementService(this._cacheManager, this._mBeanServer, this._registerCacheManager, this._registerCaches, this._registerCacheConfigurations, this._registerCacheStatistics);
            this._managementService.init();
        }
    }

    public void clearAll() {
        this._cacheManager.clearAll();
    }

    public void destroy() throws Exception {
        try {
            this._cacheManager.shutdown();
        }
        finally {
            if (this._managementService != null) {
                this._managementService.dispose();
            }
        }
    }

    public PortalCache<K, V> getCache(String name) {
        return this.getCache(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortalCache<K, V> getCache(String name, boolean blocking) {
        PortalCache<K, V> portalCache = this._ehcachePortalCaches.get(name);
        if (portalCache == null) {
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                portalCache = this._ehcachePortalCaches.get(name);
                if (portalCache == null) {
                    portalCache = this.addCache(name, null);
                }
            }
        }
        if (PropsValues.TRANSACTIONAL_CACHE_ENABLED && (name.startsWith(EntityCacheImpl.CACHE_NAME) || name.startsWith(FinderCacheImpl.CACHE_NAME))) {
            portalCache = new PortalCache<K, V>(portalCache);
        }
        if (PropsValues.EHCACHE_BLOCKING_CACHE_ALLOWED && blocking) {
            portalCache = new PortalCache<K, V>((PortalCache)portalCache);
        }
        return portalCache;
    }

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    public void reconfigureCaches(URL configurationURL) {
        Configuration configuration = EhcacheConfigurationUtil.getConfiguration(configurationURL, this._clusterAware, this._usingDefault);
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            Cache cache = new Cache(cacheConfiguration);
            PortalCache<K, V> portalCache = this.addCache(cache.getName(), cache);
            if (portalCache != null) continue;
            _log.error((Object)("Failed to override cache " + cacheConfiguration.getName()));
        }
    }

    public void removeCache(String name) {
        this._ehcachePortalCaches.remove(name);
        this._cacheManager.removeCache(name);
    }

    public void setClusterAware(boolean clusterAware) {
        this._clusterAware = clusterAware;
    }

    public void setConfigPropertyKey(String configPropertyKey) {
        this._configPropertyKey = configPropertyKey;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public void setMpiOnly(boolean mpiOnly) {
        this._mpiOnly = mpiOnly;
    }

    public void setRegisterCacheConfigurations(boolean registerCacheConfigurations) {
        this._registerCacheConfigurations = registerCacheConfigurations;
    }

    public void setRegisterCacheManager(boolean registerCacheManager) {
        this._registerCacheManager = registerCacheManager;
    }

    public void setRegisterCaches(boolean registerCaches) {
        this._registerCaches = registerCaches;
    }

    public void setRegisterCacheStatistics(boolean registerCacheStatistics) {
        this._registerCacheStatistics = registerCacheStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortalCache<K, V> addCache(String name, Cache cache) {
        EhcachePortalCache<K, V> ehcachePortalCache = null;
        CacheManager cacheManager = this._cacheManager;
        synchronized (cacheManager) {
            Ehcache ehcache;
            block11: {
                if (cache != null && this._cacheManager.cacheExists(name)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Overriding existing cache " + name));
                    }
                    this._cacheManager.removeCache(name);
                }
                if (cache == null) {
                    if (!this._cacheManager.cacheExists(name)) {
                        this._cacheManager.addCache(name);
                    }
                } else {
                    this._cacheManager.addCache(cache);
                }
                if ((ehcache = this._cacheManager.getEhcache(name)) != null) break block11;
                return null;
            }
            ehcache.setStatisticsEnabled(PropsValues.EHCACHE_STATISTICS_ENABLED);
            ehcachePortalCache = this._ehcachePortalCaches.get(name);
            if (ehcachePortalCache == null) {
                ehcachePortalCache = new EhcachePortalCache(ehcache);
                this._ehcachePortalCaches.put(name, ehcachePortalCache);
            } else {
                ehcachePortalCache.setEhcache(ehcache);
            }
        }
        return ehcachePortalCache;
    }
}

