/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask.messaging;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.backgroundtask.executor.BackgroundTaskExecutor;
import com.liferay.portal.backgroundtask.executor.ClassLoaderAwareBackgroundTaskExecutor;
import com.liferay.portal.backgroundtask.executor.SerialBackgroundTaskExecutor;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.ClassLoaderUtil;

public class BackgroundTaskMessageListener
extends BaseMessageListener {
    protected void doReceive(Message message) throws Exception {
        long backgroundTaskId = (Long)message.get("backgroundTaskId");
        ServiceContext serviceContext = new ServiceContext();
        BackgroundTaskLocalServiceUtil.updateBackgroundTask((long)backgroundTaskId, null, (int)1, (ServiceContext)serviceContext);
        BackgroundTask backgroundTask = BackgroundTaskLocalServiceUtil.getBackgroundTask((long)backgroundTaskId);
        int status = backgroundTask.getStatus();
        try {
            try {
                ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
                String servletContextNames = backgroundTask.getServletContextNames();
                if (Validator.isNotNull((String)servletContextNames)) {
                    classLoader = ClassLoaderUtil.getAggregatePluginsClassLoader(StringUtil.split((String)servletContextNames), false);
                }
                BackgroundTaskExecutor backgroundTaskExecutor = (BackgroundTaskExecutor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)backgroundTask.getTaskExecutorClassName());
                backgroundTaskExecutor = this.wrapBackgroundTaskExecutor(backgroundTaskExecutor, classLoader);
                backgroundTaskExecutor.execute(backgroundTask);
                status = 3;
            }
            catch (DuplicateLockException duplicateLockException) {
                status = 4;
                BackgroundTaskLocalServiceUtil.updateBackgroundTask((long)backgroundTaskId, null, (int)status, (ServiceContext)serviceContext);
                Message responseMessage = new Message();
                responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                responseMessage.put("name", (Object)backgroundTask.getName());
                responseMessage.put("status", (Object)status);
                responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)responseMessage);
            }
            catch (Exception exception) {
                status = 2;
                BackgroundTaskLocalServiceUtil.updateBackgroundTask((long)backgroundTaskId, null, (int)status, (ServiceContext)serviceContext);
                Message responseMessage = new Message();
                responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                responseMessage.put("name", (Object)backgroundTask.getName());
                responseMessage.put("status", (Object)status);
                responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)responseMessage);
            }
        }
        finally {
            BackgroundTaskLocalServiceUtil.updateBackgroundTask((long)backgroundTaskId, null, (int)status, (ServiceContext)serviceContext);
            Message responseMessage = new Message();
            responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
            responseMessage.put("name", (Object)backgroundTask.getName());
            responseMessage.put("status", (Object)status);
            responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
            MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)responseMessage);
        }
    }

    protected BackgroundTaskExecutor wrapBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, ClassLoader classLoader) {
        if (classLoader != ClassLoaderUtil.getPortalClassLoader()) {
            backgroundTaskExecutor = new ClassLoaderAwareBackgroundTaskExecutor(backgroundTaskExecutor, classLoader);
        }
        if (backgroundTaskExecutor.isSerial()) {
            backgroundTaskExecutor = new SerialBackgroundTaskExecutor(backgroundTaskExecutor);
        }
        return backgroundTaskExecutor;
    }
}

