/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask.executor;

import com.liferay.portal.backgroundtask.executor.BackgroundTaskExecutor;
import com.liferay.portal.backgroundtask.executor.BaseBackgroundTaskExecutor;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;

public class SerialBackgroundTaskExecutor
implements BackgroundTaskExecutor {
    private BackgroundTaskExecutor _backgroundTaskExecutor;

    public SerialBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor) {
        this._backgroundTaskExecutor = backgroundTaskExecutor;
    }

    @Override
    public void execute(BackgroundTask backgroundTask) throws Exception {
        Lock lock = null;
        try {
            if (this.isSerial()) {
                String owner = String.valueOf(backgroundTask.getName()) + "#" + backgroundTask.getBackgroundTaskId();
                lock = LockLocalServiceUtil.lock((long)backgroundTask.getUserId(), (String)BackgroundTaskExecutor.class.getName(), (String)backgroundTask.getTaskExecutorClassName(), (String)owner, (boolean)false, (long)0L);
            }
            this._backgroundTaskExecutor.execute(backgroundTask);
        }
        finally {
            if (lock != null) {
                LockLocalServiceUtil.unlock((String)BaseBackgroundTaskExecutor.class.getName(), (String)backgroundTask.getTaskExecutorClassName());
            }
        }
    }

    @Override
    public boolean isSerial() {
        return this._backgroundTaskExecutor.isSerial();
    }
}

