/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask.executor;

import com.liferay.portal.backgroundtask.executor.BackgroundTaskExecutor;
import com.liferay.portal.model.BackgroundTask;

public class ClassLoaderAwareBackgroundTaskExecutor
implements BackgroundTaskExecutor {
    private BackgroundTaskExecutor _backgroundTaskExecutor;
    private ClassLoader _classLoader;

    public ClassLoaderAwareBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, ClassLoader classLoader) {
        this._backgroundTaskExecutor = backgroundTaskExecutor;
        this._classLoader = classLoader;
    }

    @Override
    public void execute(BackgroundTask backgroundTask) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (this._classLoader != contextClassLoader) {
            currentThread.setContextClassLoader(this._classLoader);
        }
        try {
            this._backgroundTaskExecutor.execute(backgroundTask);
        }
        finally {
            if (this._classLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    @Override
    public boolean isSerial() {
        return this._backgroundTaskExecutor.isSerial();
    }
}

