/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.atom.AtomRequestContextImpl;
import com.liferay.portal.atom.BaseEntityCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomException;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;

public class AtomCollectionAdapterWrapper<E>
extends BaseEntityCollectionAdapter<E> {
    private AtomCollectionAdapter<E> _atomCollectionAdapter;

    public AtomCollectionAdapterWrapper(AtomCollectionAdapter<E> atomCollectionAdapter) {
        super(atomCollectionAdapter.getCollectionName().toLowerCase());
        this._atomCollectionAdapter = atomCollectionAdapter;
    }

    public void deleteEntry(String resourceName, RequestContext requestContext) throws ResponseContextException {
        try {
            this._atomCollectionAdapter.deleteEntry(resourceName, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public List<Person> getAuthors(E entry, RequestContext requestContext) {
        ArrayList<Person> persons = new ArrayList<Person>();
        List authors = this._atomCollectionAdapter.getEntryAuthors(entry);
        for (String author : authors) {
            Abdera abdera = requestContext.getAbdera();
            Factory factory = abdera.getFactory();
            Person person = factory.newAuthor();
            person.setName(author);
            persons.add(person);
        }
        return persons;
    }

    public Object getContent(E entry, RequestContext requestContext) {
        AtomEntryContent atomEntryContent = this._atomCollectionAdapter.getEntryContent(entry, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        Content content = this.newContent(atomEntryContent.getType(), requestContext);
        if (atomEntryContent.getMimeType() != null) {
            content.setMimeType(atomEntryContent.getMimeType());
        }
        if (atomEntryContent.getSrcLink() != null) {
            content.setSrc(atomEntryContent.getSrcLink());
        }
        content.setText(atomEntryContent.getText());
        return content;
    }

    public String getContentType(E entry) {
        return this._atomCollectionAdapter.getMediaContentType(entry);
    }

    public Iterable<E> getEntries(RequestContext requestContext) throws ResponseContextException {
        try {
            return this._atomCollectionAdapter.getFeedEntries((AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public E getEntry(String resourceName, RequestContext requestContext) throws ResponseContextException {
        try {
            if (resourceName.endsWith(":media")) {
                resourceName = resourceName.substring(0, resourceName.length() - 6);
            }
            return (E)this._atomCollectionAdapter.getEntry(resourceName, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public String getMediaName(E entry) throws ResponseContextException {
        try {
            return this._atomCollectionAdapter.getMediaName(entry);
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public InputStream getMediaStream(E entry) throws ResponseContextException {
        try {
            return this._atomCollectionAdapter.getMediaStream(entry);
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public Text getSummary(E entry, RequestContext request) {
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        Text summary = factory.newSummary();
        summary.setValue(this._atomCollectionAdapter.getEntrySummary(entry));
        return summary;
    }

    public String getTitle(E entry) {
        return this._atomCollectionAdapter.getEntryTitle(entry);
    }

    public String getTitle(RequestContext requestContext) {
        return this._atomCollectionAdapter.getFeedTitle((AtomRequestContext)new AtomRequestContextImpl(requestContext));
    }

    public Date getUpdated(E entry) {
        return this._atomCollectionAdapter.getEntryUpdated(entry);
    }

    public E postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext requestContext) throws ResponseContextException {
        try {
            return (E)this._atomCollectionAdapter.postEntry(title, summary, content.getText(), updated, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public E postMedia(MimeType mimeType, String slug, InputStream inputStream, RequestContext requestContext) throws ResponseContextException {
        try {
            return (E)this._atomCollectionAdapter.postMedia(mimeType.toString(), slug, inputStream, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public void putEntry(E entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext requestContext) throws ResponseContextException {
        try {
            this._atomCollectionAdapter.putEntry(entry, title, summary, content.getText(), updated, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    public void putMedia(E entry, MimeType contentType, String slug, InputStream inputStream, RequestContext requestContext) throws ResponseContextException {
        try {
            this._atomCollectionAdapter.putMedia(entry, contentType.toString(), slug, inputStream, (AtomRequestContext)new AtomRequestContextImpl(requestContext));
        }
        catch (AtomException ae) {
            throw new ResponseContextException(ae.getErrorCode(), ae.getCause());
        }
    }

    @Override
    protected String getEntryId(E entry) {
        return this._atomCollectionAdapter.getEntryId(entry);
    }

    protected Content newContent(AtomEntryContent.Type atomEntryContentType, RequestContext requestContext) {
        Abdera abdera = requestContext.getAbdera();
        Factory factory = abdera.getFactory();
        if (atomEntryContentType == AtomEntryContent.Type.HTML) {
            return factory.newContent(Content.Type.HTML);
        }
        if (atomEntryContentType == AtomEntryContent.Type.MEDIA) {
            return factory.newContent(Content.Type.MEDIA);
        }
        if (atomEntryContentType == AtomEntryContent.Type.TEXT) {
            return factory.newContent(Content.Type.TEXT);
        }
        if (atomEntryContentType == AtomEntryContent.Type.XHTML) {
            return factory.newContent(Content.Type.XHTML);
        }
        if (atomEntryContentType == AtomEntryContent.Type.XML) {
            return factory.newContent(Content.Type.XML);
        }
        throw new IllegalArgumentException();
    }
}

