/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apache.bridges.struts;

import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletServletRequest;
import com.liferay.portlet.PortletServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiferayRequestDispatcher
implements RequestDispatcher {
    private String _path;
    private RequestDispatcher _requestDispatcher;

    public LiferayRequestDispatcher(RequestDispatcher requestDispatcher, String path) {
        this._requestDispatcher = requestDispatcher;
        this._path = path;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            this.invoke(servletRequest, servletResponse, false);
        } else {
            this._requestDispatcher.forward(servletRequest, servletResponse);
        }
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse, boolean named) throws IOException, ServletException {
        this.forward(servletRequest, servletResponse);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            this.invoke(servletRequest, servletResponse, true);
        } else {
            this._requestDispatcher.include(servletRequest, servletResponse);
        }
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse, boolean named) throws IOException, ServletException {
        this.include(servletRequest, servletResponse);
    }

    public void invoke(ServletRequest servletRequest, ServletResponse servletResponse, boolean include) throws IOException, ServletException {
        String pathInfo = null;
        String queryString = null;
        String requestURI = null;
        String servletPath = null;
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)servletRequest.getAttribute("javax.portlet.response");
        if (this._path != null) {
            String pathNoQueryString = this._path;
            int pos = this._path.indexOf(63);
            if (pos != -1) {
                pathNoQueryString = this._path.substring(0, pos);
                queryString = this._path.substring(pos + 1);
            }
            Set<String> servletURLPatterns = this.getServletURLPatterns(servletRequest, portletRequest, portletResponse);
            for (String urlPattern : servletURLPatterns) {
                if (!urlPattern.endsWith("/*") || !pathNoQueryString.startsWith(urlPattern = urlPattern.substring(0, (pos = urlPattern.indexOf("/*")) + 1))) continue;
                pathInfo = pathNoQueryString.substring(urlPattern.length());
                servletPath = urlPattern;
                break;
            }
            if (pathInfo == null && servletPath == null) {
                pathInfo = "";
                servletPath = pathNoQueryString;
            }
            requestURI = String.valueOf(portletRequest.getContextPath()) + pathNoQueryString;
        }
        HttpServletRequest portletServletRequest = this.getPortletServletRequest(servletRequest, portletRequest, pathInfo, queryString, requestURI, servletPath, include);
        HttpServletResponse portletServletResponse = this.getPortletServletResponse(servletResponse, portletRequest, portletResponse, include);
        if (include) {
            this._requestDispatcher.include((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
        } else {
            this._requestDispatcher.forward((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
        }
    }

    public void invoke(ServletRequest servletRequest, ServletResponse servletResponse, boolean named, boolean include) throws IOException, ServletException {
        this.invoke(servletRequest, servletResponse, include);
    }

    protected HttpServletRequest getPortletServletRequest(ServletRequest servletRequest, PortletRequest portletRequest, String pathInfo, String queryString, String requestURI, String servletPath, boolean include) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        boolean named = false;
        PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
        return new PortletServletRequest(request, (PortletRequest)portletRequestImpl, pathInfo, queryString, requestURI, servletPath, named, include);
    }

    protected HttpServletResponse getPortletServletResponse(ServletResponse servletResponse, PortletRequest portletRequest, PortletResponse portletResponse, boolean include) throws IOException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        PortletResponseImpl portletResponseImpl = (PortletResponseImpl)portletResponse;
        PortletServletResponse httpServletResponse = new PortletServletResponse(response, (PortletResponse)portletResponseImpl, include);
        PrintWriter printWriter = servletResponse.getWriter();
        if (printWriter != null) {
            httpServletResponse = new PipingServletResponse((HttpServletResponse)httpServletResponse, printWriter);
        }
        return httpServletResponse;
    }

    protected Set<String> getServletURLPatterns(ServletRequest servletRequest, PortletRequest portletRequest, PortletResponse portletResponse) {
        PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
        Portlet portlet = portletRequestImpl.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        return portletApp.getServletURLPatterns();
    }
}

