create table QUARTZ_BLOB_TRIGGERS (
	SCHED_NAME VARCHAR(120) not null,
	TRIGGER_NAME VARCHAR(200) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	BLOB_DATA SBLOB null,
	primary key (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);

create table QUARTZ_CALENDARS (
	SCHED_NAME VARCHAR(120) not null,
	CALENDAR_NAME VARCHAR(200) not null,
	CALENDAR SBLOB not null,
	primary key (SCHED_NAME,CALENDAR_NAME)
);

create table QUARTZ_CRON_TRIGGERS (
	SCHED_NAME VARCHAR(120) not null,
	TRIGGER_NAME VARCHAR(200) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	CRON_EXPRESSION VARCHAR(200) not null,
	TIME_ZONE_ID VARCHAR(80),
	primary key (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);

create table QUARTZ_FIRED_TRIGGERS (
	SCHED_NAME VARCHAR(120) not null,
	ENTRY_ID VARCHAR(95) not null,
	TRIGGER_NAME VARCHAR(200) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	INSTANCE_NAME VARCHAR(200) not null,
	FIRED_TIME LONG not null,
	PRIORITY INTEGER not null,
	STATE VARCHAR(16) not null,
	JOB_NAME VARCHAR(200) null,
	JOB_GROUP VARCHAR(200) null,
	IS_NONCONCURRENT BOOLEAN NULL,
	REQUESTS_RECOVERY BOOLEAN NULL,
	primary key (SCHED_NAME, ENTRY_ID)
);

create table QUARTZ_JOB_DETAILS (
	SCHED_NAME VARCHAR(120) not null,
	JOB_NAME VARCHAR(200) not null,
	JOB_GROUP VARCHAR(200) not null,
	DESCRIPTION VARCHAR(250) null,
	JOB_CLASS_NAME VARCHAR(250) not null,
	IS_DURABLE BOOLEAN not null,
	IS_NONCONCURRENT BOOLEAN not null,
	IS_UPDATE_DATA BOOLEAN not null,
	REQUESTS_RECOVERY BOOLEAN not null,
	JOB_DATA SBLOB null,
	primary key (SCHED_NAME, JOB_NAME, JOB_GROUP)
);

create table QUARTZ_LOCKS (
	SCHED_NAME VARCHAR(120) not null,
	LOCK_NAME VARCHAR(40) not null ,
	primary key (SCHED_NAME, LOCK_NAME)
);

create table QUARTZ_PAUSED_TRIGGER_GRPS (
	SCHED_NAME VARCHAR(120) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	primary key (SCHED_NAME, TRIGGER_GROUP)
);

create table QUARTZ_SCHEDULER_STATE (
	SCHED_NAME VARCHAR(120) not null,
	INSTANCE_NAME VARCHAR(200) not null,
	LAST_CHECKIN_TIME LONG not null,
	CHECKIN_INTERVAL LONG not null,
	primary key (SCHED_NAME, INSTANCE_NAME)
);

create table QUARTZ_SIMPLE_TRIGGERS (
	SCHED_NAME VARCHAR(120) not null,
	TRIGGER_NAME VARCHAR(200) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	REPEAT_COUNT LONG not null,
	REPEAT_INTERVAL LONG not null,
	TIMES_TRIGGERED LONG not null,
	primary key (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);

CREATE TABLE QUARTZ_SIMPROP_TRIGGERS (
	SCHED_NAME VARCHAR(120) not null,
	TRIGGER_NAME VARCHAR(200) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	STR_PROP_1 VARCHAR(512) null,
	STR_PROP_2 VARCHAR(512) null,
	STR_PROP_3 VARCHAR(512) null,
	INT_PROP_1 INTEGER null,
	INT_PROP_2 INTEGER null,
	LONG_PROP_1 LONG null,
	LONG_PROP_2 LONG null,
	DEC_PROP_1 NUMERIC(13,4) null,
	DEC_PROP_2 NUMERIC(13,4) null,
	BOOL_PROP_1 BOOLEAN null,
	BOOL_PROP_2 BOOLEAN null,
	primary key (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);

create table QUARTZ_TRIGGERS (
	SCHED_NAME VARCHAR(120) not null,
	TRIGGER_NAME VARCHAR(200) not null,
	TRIGGER_GROUP VARCHAR(200) not null,
	JOB_NAME VARCHAR(200) not null,
	JOB_GROUP VARCHAR(200) not null,
	DESCRIPTION VARCHAR(250) null,
	NEXT_FIRE_TIME LONG null,
	PREV_FIRE_TIME LONG null,
	PRIORITY INTEGER null,
	TRIGGER_STATE VARCHAR(16) not null,
	TRIGGER_TYPE VARCHAR(8) not null,
	START_TIME LONG not null,
	END_TIME LONG null,
	CALENDAR_NAME VARCHAR(200) null,
	MISFIRE_INSTR INTEGER null,
	JOB_DATA SBLOB null,
	primary key  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);

COMMIT_TRANSACTION;

create index IX_88328984 on QUARTZ_JOB_DETAILS (SCHED_NAME, JOB_GROUP);
create index IX_779BCA37 on QUARTZ_JOB_DETAILS (SCHED_NAME, REQUESTS_RECOVERY);

create index IX_BE3835E5 on QUARTZ_FIRED_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
create index IX_4BD722BM on QUARTZ_FIRED_TRIGGERS (SCHED_NAME, TRIGGER_GROUP);
create index IX_204D31E8 on QUARTZ_FIRED_TRIGGERS (SCHED_NAME, INSTANCE_NAME);
create index IX_339E078M on QUARTZ_FIRED_TRIGGERS (SCHED_NAME, INSTANCE_NAME, REQUESTS_RECOVERY);
create index IX_5005E3AF on QUARTZ_FIRED_TRIGGERS (SCHED_NAME, JOB_NAME, JOB_GROUP);
create index IX_BC2F03B0 on QUARTZ_FIRED_TRIGGERS (SCHED_NAME, JOB_GROUP);

create index IX_186442A4 on QUARTZ_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_STATE);
create index IX_1BA1F9DC on QUARTZ_TRIGGERS (SCHED_NAME, TRIGGER_GROUP);
create index IX_91CA7CCE on QUARTZ_TRIGGERS (SCHED_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, TRIGGER_STATE, MISFIRE_INSTR);
create index IX_D219AFDE on QUARTZ_TRIGGERS (SCHED_NAME, TRIGGER_GROUP, TRIGGER_STATE);
create index IX_A85822A0 on QUARTZ_TRIGGERS (SCHED_NAME, JOB_NAME, JOB_GROUP);
create index IX_8AA50BE1 on QUARTZ_TRIGGERS (SCHED_NAME, JOB_GROUP);
create index IX_EEFE382A on QUARTZ_TRIGGERS (SCHED_NAME, NEXT_FIRE_TIME);
create index IX_F026CF4C on QUARTZ_TRIGGERS (SCHED_NAME, NEXT_FIRE_TIME, TRIGGER_STATE);
create index IX_F2DD7C7E on QUARTZ_TRIGGERS (SCHED_NAME, NEXT_FIRE_TIME, TRIGGER_STATE, MISFIRE_INSTR);
create index IX_1F92813C on QUARTZ_TRIGGERS (SCHED_NAME, NEXT_FIRE_TIME, MISFIRE_INSTR);
create index IX_99108B6E on QUARTZ_TRIGGERS (SCHED_NAME, TRIGGER_STATE);
create index IX_CD7132D0 on QUARTZ_TRIGGERS (SCHED_NAME, CALENDAR_NAME);