/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.workflowdefinitions.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.workflowdefinitions.action.ActionUtil;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditWorkflowDefinitionAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateWorkflowDefinition(actionRequest);
            } else if (cmd.equals("deactivate") || cmd.equals("delete") || cmd.equals("restore")) {
                this.deleteWorkflowDefinition(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof WorkflowDefinitionFileException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof WorkflowException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.workflow_definitions.error");
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getWorkflowDefinition((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof WorkflowException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.workflow_definitions.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.workflow_definitions.edit_workflow_definition"));
    }

    protected void deleteWorkflowDefinition(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int version = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"version");
        if (cmd.equals("deactivate") || cmd.equals("restore")) {
            boolean active = !cmd.equals("deactivate");
            WorkflowDefinitionManagerUtil.updateActive((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (String)name, (int)version, (boolean)active);
        } else {
            WorkflowDefinitionManagerUtil.undeployWorkflowDefinition((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (String)name, (int)version);
        }
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void updateWorkflowDefinition(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("file");
            WorkflowDefinition workflowDefinition = null;
            if (inputStream == null) {
                String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
                int version = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"version");
                workflowDefinition = WorkflowDefinitionManagerUtil.getWorkflowDefinition((long)themeDisplay.getCompanyId(), (String)name, (int)version);
                WorkflowDefinitionManagerUtil.updateTitle((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (String)name, (int)version, (String)this.getTitle(titleMap));
            } else {
                workflowDefinition = WorkflowDefinitionManagerUtil.deployWorkflowDefinition((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (String)this.getTitle(titleMap), (InputStream)inputStream);
            }
            actionRequest.setAttribute("WORKFLOW_DEFINITION", (Object)workflowDefinition);
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
        }
    }

    protected String getTitle(Map<Locale, String> titleMap) {
        Locale[] locales;
        if (titleMap == null) {
            return null;
        }
        String value = "";
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String title = titleMap.get(locale);
            value = Validator.isNotNull((String)title) ? LocalizationUtil.updateLocalization((String)value, (String)"Title", (String)title, (String)languageId) : LocalizationUtil.removeLocalization((String)value, (String)"Title", (String)languageId);
            ++n2;
        }
        return value;
    }
}

