/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.lar.WikiPortletDataHandlerImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "wiki";
    private static Log _log = LogFactoryUtil.getLog(WikiDisplayPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("wiki", "attachments");
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("wiki", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("wiki", "comments");
    private static PortletDataHandlerBoolean _nodesAndPages = new PortletDataHandlerBoolean("wiki", "wikis-and-pages", true, true);
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("wiki", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences2 = super.importData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletPreferences.setValue("title", "");
        portletPreferences.setValue("nodeId", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No node id found in preferences of portlet " + portletId));
            }
            return "";
        }
        String title = portletPreferences.getValue("title", null);
        if (title == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No title found in preferences of portlet " + portletId));
            }
            return "";
        }
        WikiNode node = null;
        try {
            node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
        }
        catch (NoSuchNodeException nsne) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsne, (Throwable)nsne);
            }
            return "";
        }
        portletDataContext.addPermissions("com.liferay.portlet.wiki", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("wiki-display-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element nodesElement = rootElement.addElement("nodes");
        Element pagesElement = rootElement.addElement("pages");
        WikiPortletDataHandlerImpl.exportNode(portletDataContext, nodesElement, pagesElement, node);
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.wiki", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element nodesElement = rootElement.element("nodes");
        for (Element nodeElement : nodesElement.elements("node")) {
            String path = nodeElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            WikiNode node = (WikiNode)portletDataContext.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importNode(portletDataContext, node);
        }
        Element pagesElement = rootElement.element("pages");
        JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, pagesElement);
        for (Element pageElement : pagesElement.elements("page")) {
            String path = pageElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            WikiPage page = (WikiPage)portletDataContext.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importPage(portletDataContext, pageElement, page);
        }
        Map nodePKs = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        Iterator iterator = nodePKs.values().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId > 0L) {
            nodeId = MapUtil.getLong((Map)nodePKs, (long)nodeId, (long)nodeId);
            portletPreferences.setValue("nodeId", String.valueOf(nodeId));
        }
        return portletPreferences;
    }
}

