/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.mediawiki;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.engines.mediawiki.matchers.EditURLMatcher;
import com.liferay.portlet.wiki.engines.mediawiki.matchers.ImageTagMatcher;
import com.liferay.portlet.wiki.engines.mediawiki.matchers.ImageURLMatcher;
import com.liferay.portlet.wiki.engines.mediawiki.matchers.ViewURLMatcher;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletURL;
import org.apache.commons.lang.LocaleUtils;
import org.jamwiki.model.WikiUser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.ParserUtil;
import org.jamwiki.parser.TableOfContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWikiEngine
implements WikiEngine {
    @Override
    public String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException {
        String html = this.parsePage(page, new ParserOutput());
        html = this.postParsePage(html, viewPageURL, editPageURL, attachmentURLPrefix);
        return html;
    }

    @Override
    public Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        ParserOutput parserOutput = this.getParserOutput(page);
        HashMap<String, Boolean> outgoingLinks = new HashMap<String, Boolean>();
        for (String title : parserOutput.getLinks()) {
            Boolean existsObj = (Boolean)outgoingLinks.get(title);
            if (existsObj != null) continue;
            int pagesCount = 0;
            try {
                pagesCount = WikiPageLocalServiceUtil.getPagesCount((long)page.getNodeId(), (String)title, (boolean)true);
            }
            catch (SystemException se) {
                throw new PageContentException((Throwable)se);
            }
            if (pagesCount > 0) {
                existsObj = Boolean.TRUE;
            } else {
                existsObj = Boolean.FALSE;
                if (StringUtil.startsWith((String)title, (String)"image:")) continue;
            }
            outgoingLinks.put(title, existsObj);
        }
        return outgoingLinks;
    }

    @Override
    public void setInterWikiConfiguration(String interWikiConfiguration) {
    }

    @Override
    public void setMainConfiguration(String mainConfiguration) {
    }

    @Override
    public boolean validate(long nodeId, String content) {
        return true;
    }

    protected ParserInput getParserInput(long nodeId, String topicName) {
        ParserInput parserInput = new ParserInput("Special:Node:" + nodeId, topicName);
        parserInput.setContext("/wiki");
        parserInput.setLocale(LocaleUtils.toLocale((String)"en_US"));
        parserInput.setUserDisplay("0.0.0.0");
        parserInput.setWikiUser(new WikiUser("DummyUser"));
        parserInput.setAllowSectionEdit(false);
        TableOfContents tableOfContents = new TableOfContents();
        tableOfContents.setForceTOC(true);
        parserInput.setTableOfContents(tableOfContents);
        return parserInput;
    }

    protected ParserOutput getParserOutput(WikiPage page) throws PageContentException {
        ParserInput parserInput = this.getParserInput(page.getNodeId(), page.getTitle());
        ParserOutput parserOutput = null;
        try {
            parserOutput = ParserUtil.parseMetadata((ParserInput)parserInput, (String)page.getContent());
        }
        catch (ParserException pe) {
            throw new PageContentException((Throwable)pe);
        }
        return parserOutput;
    }

    protected String parsePage(WikiPage page, ParserOutput parserOutput) throws PageContentException {
        ParserInput parserInput = this.getParserInput(page.getNodeId(), page.getTitle());
        String content = "";
        try {
            content = page.getContent();
            ImageTagMatcher imageTagMatcher = new ImageTagMatcher();
            content = ParserUtil.parse((ParserInput)parserInput, (ParserOutput)parserOutput, (String)imageTagMatcher.replaceMatches(content));
        }
        catch (ParserException pe) {
            throw new PageContentException((Throwable)pe);
        }
        return content;
    }

    protected String postParsePage(String content, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        if (editPageURL != null) {
            EditURLMatcher editURLMatcher = new EditURLMatcher(editPageURL);
            content = editURLMatcher.replaceMatches(content);
        }
        if (attachmentURLPrefix != null) {
            ImageURLMatcher imageURLMatcher = new ImageURLMatcher(attachmentURLPrefix);
            content = imageURLMatcher.replaceMatches(content);
        }
        if (viewPageURL != null) {
            ViewURLMatcher viewURLMatcher = new ViewURLMatcher(viewPageURL);
            content = viewURLMatcher.replaceMatches(content);
        }
        return content;
    }
}

