/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEngine
implements WikiEngine {
    private static Log _log = LogFactoryUtil.getLog(HtmlEngine.class);
    private String _friendlyURLMapping;
    private Router _router;

    public HtmlEngine() {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)"36");
        this._friendlyURLMapping = "/-/" + portlet.getFriendlyURLMapping();
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        this._router = friendlyURLMapper.getRouter();
    }

    @Override
    public String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        return page.getContent();
    }

    @Override
    public Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        try {
            return this._getOutgoingLinks(page);
        }
        catch (Exception e) {
            throw new PageContentException((Throwable)e);
        }
    }

    @Override
    public void setInterWikiConfiguration(String interWikiConfiguration) {
    }

    @Override
    public void setMainConfiguration(String mainConfiguration) {
    }

    @Override
    public boolean validate(long nodeId, String newContent) {
        return true;
    }

    protected Map<String, Boolean> _getOutgoingLinks(WikiPage page) throws Exception {
        if (Validator.isNull((String)page.getContent())) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> links = new HashMap<String, Boolean>();
        Source source = new Source((CharSequence)page.getContent());
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            HashMap routeParameters;
            String href = startTag.getAttributeValue("href");
            if (Validator.isNull((String)href)) continue;
            int pos = href.lastIndexOf(this._friendlyURLMapping);
            String friendlyURL = href.substring(pos + this._friendlyURLMapping.length());
            if (friendlyURL.endsWith("/")) {
                friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
            }
            if (!this._router.urlToParameters(friendlyURL, routeParameters = new HashMap())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No route could be found to match URL " + friendlyURL));
                continue;
            }
            String title = (String)routeParameters.get("title");
            String nodeName = (String)routeParameters.get("nodeName");
            if (Validator.isNull((String)title) || Validator.isNull((String)nodeName)) continue;
            try {
                WikiNodeLocalServiceUtil.getNode((long)page.getGroupId(), (String)nodeName);
                links.put(title.toLowerCase(), Boolean.TRUE);
            }
            catch (NoSuchNodeException nsne) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)nsne.getMessage());
            }
        }
        return links;
    }
}

