/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static WikiNode getFirstVisibleNode(PortletRequest portletRequest) throws PortalException, SystemException {
        ServiceContext serviceContext;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        WikiNode node = null;
        int nodesCount = WikiNodeLocalServiceUtil.getNodesCount((long)themeDisplay.getScopeGroupId());
        if (nodesCount == 0) {
            Layout layout = themeDisplay.getLayout();
            serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)portletRequest);
            serviceContext.setAddGroupPermissions(true);
            if (layout.isPublicLayout()) {
                serviceContext.setAddGuestPermissions(true);
            } else {
                serviceContext.setAddGuestPermissions(false);
            }
        } else {
            node = WikiUtil.getFirstNode(portletRequest);
            if (node == null) {
                throw new PrincipalException();
            }
            return node;
        }
        node = WikiNodeLocalServiceUtil.addDefaultNode((long)themeDisplay.getUserId(), (ServiceContext)serviceContext);
        portletRequest.setAttribute("WIKI_NODE", (Object)node);
        return node;
    }

    public static WikiNode getNode(PortletRequest portletRequest) throws Exception {
        WikiNode node;
        HttpServletRequest request;
        block4: {
            request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
            String nodeName = ParamUtil.getString((HttpServletRequest)request, (String)"nodeName");
            node = null;
            try {
                if (nodeId > 0L) {
                    node = WikiNodeServiceUtil.getNode((long)nodeId);
                    break block4;
                }
                if (Validator.isNotNull((String)nodeName)) {
                    node = WikiNodeServiceUtil.getNode((long)themeDisplay.getScopeGroupId(), (String)nodeName);
                    break block4;
                }
                throw new NoSuchNodeException();
            }
            catch (NoSuchNodeException noSuchNodeException) {
                node = ActionUtil.getFirstVisibleNode(portletRequest);
            }
        }
        request.setAttribute("WIKI_NODE", (Object)node);
        return node;
    }

    public static void getPage(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
        String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version");
        WikiNode node = null;
        try {
            if (nodeId > 0L) {
                node = WikiNodeServiceUtil.getNode((long)nodeId);
            }
        }
        catch (NoSuchNodeException noSuchNodeException) {}
        if (node == null && (node = (WikiNode)request.getAttribute("WIKI_NODE")) != null) {
            nodeId = node.getNodeId();
        }
        if (Validator.isNull((String)title)) {
            title = WikiPageConstants.FRONT_PAGE;
        }
        WikiPage page = null;
        try {
            page = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
        }
        catch (NoSuchPageException nspe) {
            if (title.equals(WikiPageConstants.FRONT_PAGE) && version == 0.0) {
                long userId = PortalUtil.getUserId((HttpServletRequest)request);
                if (userId == 0L) {
                    long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
                    userId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
                }
                ServiceContext serviceContext = new ServiceContext();
                Layout layout = themeDisplay.getLayout();
                serviceContext.setAddGroupPermissions(true);
                if (layout.isPublicLayout()) {
                    serviceContext.setAddGuestPermissions(true);
                } else {
                    serviceContext.setAddGuestPermissions(false);
                }
                boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
                try {
                    WorkflowThreadLocal.setEnabled((boolean)false);
                    page = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)title, null, (String)"New", (boolean)true, (ServiceContext)serviceContext);
                }
                finally {
                    WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                }
            }
            throw nspe;
        }
        request.setAttribute("WIKI_PAGE", (Object)page);
    }

    public static void getPage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getPage(request);
    }
}

