/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;

public class OrganizationIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{Organization.class.getName()};
    public static final String PORTLET_ID = "125";
    private static final boolean _PERMISSION_AWARE = true;

    public OrganizationIndexer() {
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isIndexerEnabled() {
        return PropsValues.ORGANIZATIONS_INDEXER_ENABLED;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params == null) {
            return;
        }
        List organizationsTree = (List)params.get("organizationsTree");
        if (organizationsTree != null && !organizationsTree.isEmpty()) {
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (Organization organization : organizationsTree) {
                String treePath = organization.buildTreePath();
                booleanQuery.addTerm("treePath", treePath, true);
            }
            contextQuery.add((Query)booleanQuery, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "parentOrganizationId", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        Organization organization = (Organization)obj;
        this.deleteDocument(organization.getCompanyId(), organization.getOrganizationId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        Organization organization = (Organization)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)organization);
        document.addKeyword("companyId", organization.getCompanyId());
        document.addText("name", organization.getName());
        document.addKeyword("organizationId", organization.getOrganizationId());
        document.addKeyword("type", organization.getType());
        document.addKeyword("parentOrganizationId", organization.getParentOrganizationId());
        String treePath = organization.buildTreePath();
        document.addKeyword("treePath", treePath);
        this.populateAddresses(document, organization.getAddresses(), organization.getRegionId(), organization.getCountryId());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("name")) {
            return "name";
        }
        if (orderByCol.equals("type")) {
            return "type";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("name");
        String content = null;
        String organizationId = document.get("organizationId");
        portletURL.setParameter("struts_action", "/users_admin/edit_organization");
        portletURL.setParameter("organizationId", organizationId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        if (obj instanceof List) {
            List organizations = (List)obj;
            for (Organization organization : organizations) {
                this.doReindex(organization);
            }
        } else if (obj instanceof Long) {
            long organizationId = (Long)obj;
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            this.doReindex(organization);
        } else if (obj instanceof long[]) {
            long[] organizationIds = (long[])obj;
            HashMap<Long, ArrayList<Document>> documentsMap = new HashMap<Long, ArrayList<Document>>();
            long[] lArray = organizationIds;
            int n = organizationIds.length;
            int n2 = 0;
            while (n2 < n) {
                long organizationId = lArray[n2];
                Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
                if (organization != null) {
                    Document document = this.getDocument(organization);
                    long companyId = organization.getCompanyId();
                    ArrayList<Document> documents = (ArrayList<Document>)documentsMap.get(companyId);
                    if (documents == null) {
                        documents = new ArrayList<Document>();
                        documentsMap.put(companyId, documents);
                    }
                    documents.add(document);
                }
                ++n2;
            }
            for (Map.Entry entry : documentsMap.entrySet()) {
                long companyId = (Long)entry.getKey();
                Collection documents = (Collection)entry.getValue();
                SearchEngineUtil.updateDocuments((long)companyId, (Collection)documents);
            }
        } else if (obj instanceof Organization) {
            Organization organization = (Organization)obj;
            Document document = this.getDocument(organization);
            SearchEngineUtil.updateDocument((long)organization.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)classPK);
        this.doReindex(organization);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexOrganizations(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexOrganizations(long companyId) throws Exception {
        int count = OrganizationLocalServiceUtil.getOrganizationsCount();
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexOrganizations(companyId, start, end);
            ++i;
        }
    }

    protected void reindexOrganizations(long companyId, int start, int end) throws Exception {
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)start, (int)end);
        if (organizations.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Organization organization : organizations) {
            Document document = this.getDocument(organization);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

